/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.api.tool.JavaMethodTool;
import com.embabel.agent.api.tool.KotlinMethodTool;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.core.ReplanRequestedException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0019H$J\u0012\u0010\u001c\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lcom/embabel/agent/api/tool/MethodTool;", "Lcom/embabel/agent/api/tool/Tool;", "instance", "", "annotation", "Lcom/embabel/agent/api/annotation/LlmTool;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/lang/Object;Lcom/embabel/agent/api/annotation/LlmTool;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getInstance", "()Ljava/lang/Object;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "", "parseArguments", "", "invokeMethod", "args", "convertResult", "result", "convertToExpectedType", "value", "targetType", "Ljava/lang/reflect/Type;", "Lcom/embabel/agent/api/tool/JavaMethodTool;", "Lcom/embabel/agent/api/tool/KotlinMethodTool;", "embabel-agent-api"})
public abstract sealed class MethodTool
implements Tool
permits JavaMethodTool, KotlinMethodTool {
    @NotNull
    private final Object instance;
    @NotNull
    private final ObjectMapper objectMapper;
    private final Logger logger;
    @NotNull
    private final Tool.Metadata metadata;

    private MethodTool(Object instance, LlmTool annotation, ObjectMapper objectMapper) {
        this.instance = instance;
        this.objectMapper = objectMapper;
        this.logger = LoggerFactory.getLogger(MethodTool.class);
        this.metadata = Tool.Metadata.Companion.invoke$default(Tool.Metadata.Companion, annotation.returnDirect(), null, 2, null);
    }

    @NotNull
    protected final Object getInstance() {
        return this.instance;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Tool.Result result;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            Map<String, Object> args = this.parseArguments(input);
            Object result2 = this.invokeMethod(args);
            result = this.convertResult(result2);
        }
        catch (Exception e) {
            Throwable actualCause;
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            if ((actualCause = throwable) instanceof ReplanRequestedException) {
                throw actualCause;
            }
            String string = actualCause.getMessage();
            if (string == null && (string = e.getMessage()) == null) {
                string = "Tool invocation failed";
            }
            String message = string;
            Object[] objectArray = new Object[]{this.getDefinition().getName(), message, actualCause};
            this.logger.error("Error invoking tool '{}': {}", objectArray);
            result = Tool.Result.Companion.error(message, actualCause);
        }
        return result;
    }

    private final Map<String, Object> parseArguments(String input) {
        Map map;
        if (StringsKt.isBlank((CharSequence)input)) {
            return MapsKt.emptyMap();
        }
        try {
            Object object = this.objectMapper.readValue(input, Map.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            map = (Map)object;
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse tool input as JSON: {}", (Object)e.getMessage());
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Nullable
    protected abstract Object invokeMethod(@NotNull Map<String, ? extends Object> var1);

    private final Tool.Result convertResult(Object result) {
        Tool.Result result2;
        Object object = result;
        if (object == null) {
            result2 = Tool.Result.Companion.text("");
        } else if (object instanceof String) {
            result2 = Tool.Result.Companion.text((String)result);
        } else if (object instanceof Tool.Result) {
            result2 = (Tool.Result)result;
        } else {
            Tool.Result result3;
            try {
                String string = this.objectMapper.writeValueAsString(result);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                result3 = Tool.Result.Companion.withArtifact(string, result);
            }
            catch (Exception exception) {
                result3 = Tool.Result.Companion.withArtifact(result.toString(), result);
            }
            result2 = result3;
        }
        return result2;
    }

    @NotNull
    protected final Object convertToExpectedType(@NotNull Object value, @NotNull Type targetType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        if (targetType instanceof Class && ((Class)targetType).isInstance(value)) {
            return value;
        }
        Type type2 = targetType;
        if (Intrinsics.areEqual((Object)type2, Integer.TYPE) || Intrinsics.areEqual((Object)type2, Integer.class)) {
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
            object = number != null ? Integer.valueOf(number.intValue()) : value;
        } else if (Intrinsics.areEqual((Object)type2, Long.TYPE) || Intrinsics.areEqual((Object)type2, Long.class)) {
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
            object = number != null ? Long.valueOf(number.longValue()) : value;
        } else if (Intrinsics.areEqual((Object)type2, Double.TYPE) || Intrinsics.areEqual((Object)type2, Double.class)) {
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
            object = number != null ? Double.valueOf(number.doubleValue()) : value;
        } else if (Intrinsics.areEqual((Object)type2, Float.TYPE) || Intrinsics.areEqual((Object)type2, Float.class)) {
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
            object = number != null ? Float.valueOf(number.floatValue()) : value;
        } else if (Intrinsics.areEqual((Object)type2, Boolean.TYPE) || Intrinsics.areEqual((Object)type2, Boolean.class)) {
            Boolean bl = value instanceof Boolean ? (Boolean)value : null;
            object = bl != null ? bl : Boolean.parseBoolean(value.toString());
        } else if (Intrinsics.areEqual((Object)type2, String.class)) {
            object = value.toString();
        } else {
            Object object2;
            try {
                object2 = this.objectMapper.convertValue(value, this.objectMapper.constructType(targetType));
                Intrinsics.checkNotNull((Object)object2);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{value, targetType, e.getMessage()};
                this.logger.warn("Failed to convert {} to {}: {}", objectArray);
                object2 = value;
            }
            object = object2;
        }
        return object;
    }

    public /* synthetic */ MethodTool(Object instance, LlmTool annotation, ObjectMapper objectMapper, DefaultConstructorMarker $constructor_marker) {
        this(instance, annotation, objectMapper);
    }
}

