/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.event;

import com.embabel.agent.api.event.AbstractAgentProcessEvent;
import com.embabel.agent.api.event.ToolLoopCompletedEvent;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.AgentProcess;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/embabel/agent/api/event/ToolLoopStartEvent;", "Lcom/embabel/agent/api/event/AbstractAgentProcessEvent;", "agentProcess", "Lcom/embabel/agent/core/AgentProcess;", "action", "Lcom/embabel/agent/core/Action;", "toolNames", "", "", "maxIterations", "", "interactionId", "outputClass", "Ljava/lang/Class;", "<init>", "(Lcom/embabel/agent/core/AgentProcess;Lcom/embabel/agent/core/Action;Ljava/util/List;ILjava/lang/String;Ljava/lang/Class;)V", "getAction", "()Lcom/embabel/agent/core/Action;", "getToolNames", "()Ljava/util/List;", "getMaxIterations", "()I", "getInteractionId", "()Ljava/lang/String;", "getOutputClass", "()Ljava/lang/Class;", "completedEvent", "Lcom/embabel/agent/api/event/ToolLoopCompletedEvent;", "totalIterations", "replanRequested", "", "embabel-agent-api"})
public final class ToolLoopStartEvent
extends AbstractAgentProcessEvent {
    @Nullable
    private final Action action;
    @NotNull
    private final List<String> toolNames;
    private final int maxIterations;
    @NotNull
    private final String interactionId;
    @NotNull
    private final Class<?> outputClass;

    public ToolLoopStartEvent(@NotNull AgentProcess agentProcess, @Nullable Action action, @NotNull List<String> toolNames, int maxIterations, @NotNull String interactionId, @NotNull Class<?> outputClass) {
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        Intrinsics.checkNotNullParameter(toolNames, (String)"toolNames");
        Intrinsics.checkNotNullParameter((Object)interactionId, (String)"interactionId");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        super(agentProcess);
        this.action = action;
        this.toolNames = toolNames;
        this.maxIterations = maxIterations;
        this.interactionId = interactionId;
        this.outputClass = outputClass;
    }

    @Nullable
    public final Action getAction() {
        return this.action;
    }

    @NotNull
    public final List<String> getToolNames() {
        return this.toolNames;
    }

    public final int getMaxIterations() {
        return this.maxIterations;
    }

    @NotNull
    public final String getInteractionId() {
        return this.interactionId;
    }

    @NotNull
    public final Class<?> getOutputClass() {
        return this.outputClass;
    }

    @NotNull
    public final ToolLoopCompletedEvent completedEvent(int totalIterations, boolean replanRequested) {
        AgentProcess agentProcess = this.getAgentProcess();
        Duration duration = Duration.between(this.getTimestamp(), Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return new ToolLoopCompletedEvent(agentProcess, this.action, this.toolNames, this.maxIterations, this.interactionId, this.outputClass, totalIterations, replanRequested, duration);
    }
}

