/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.ux.form;

import com.embabel.ux.form.Button;
import com.embabel.ux.form.Checkbox;
import com.embabel.ux.form.Control;
import com.embabel.ux.form.ControlValue;
import com.embabel.ux.form.DatePicker;
import com.embabel.ux.form.DefaultFormProcessorKt;
import com.embabel.ux.form.Dropdown;
import com.embabel.ux.form.FileUpload;
import com.embabel.ux.form.Form;
import com.embabel.ux.form.FormProcessor;
import com.embabel.ux.form.FormSubmission;
import com.embabel.ux.form.FormSubmissionResult;
import com.embabel.ux.form.FormValidator;
import com.embabel.ux.form.RadioGroup;
import com.embabel.ux.form.RequirableControl;
import com.embabel.ux.form.Slider;
import com.embabel.ux.form.TextArea;
import com.embabel.ux.form.TextField;
import com.embabel.ux.form.TimePicker;
import com.embabel.ux.form.Toggle;
import com.embabel.ux.form.ValidationResult;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/embabel/ux/form/DefaultFormProcessor;", "Lcom/embabel/ux/form/FormProcessor;", "<init>", "()V", "processSubmission", "Lcom/embabel/ux/form/FormSubmissionResult;", "form", "Lcom/embabel/ux/form/Form;", "submission", "Lcom/embabel/ux/form/FormSubmission;", "convertToControlValue", "Lcom/embabel/ux/form/ControlValue;", "value", "", "control", "Lcom/embabel/ux/form/Control;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nDefaultFormProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFormProcessor.kt\ncom/embabel/ux/form/DefaultFormProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n827#2:261\n855#2,2:262\n1863#2:264\n1863#2,2:265\n1864#2:267\n1557#2:268\n1628#2,3:269\n1557#2:272\n1628#2,3:273\n*S KotlinDebug\n*F\n+ 1 DefaultFormProcessor.kt\ncom/embabel/ux/form/DefaultFormProcessor\n*L\n135#1:261\n135#1:262,2\n138#1:264\n146#1:265,2\n138#1:267\n189#1:268\n189#1:269,3\n190#1:272\n190#1:273,3\n*E\n"})
public final class DefaultFormProcessor
implements FormProcessor {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FormSubmissionResult processSubmission(@NotNull Form form, @NotNull FormSubmission submission) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        Intrinsics.checkNotNullParameter((Object)submission, (String)"submission");
        if (!Intrinsics.areEqual((Object)form.getId(), (Object)submission.getFormId())) {
            boolean $i$a$-require-DefaultFormProcessor$processSubmission$22 = false;
            String $i$a$-require-DefaultFormProcessor$processSubmission$22 = "Form ID in submission does not match the form ID";
            throw new IllegalArgumentException($i$a$-require-DefaultFormProcessor$processSubmission$22.toString());
        }
        Map validators = DefaultFormProcessorKt.access$defaultValidatorsFor(form);
        Map processedValues = new LinkedHashMap();
        Map errors = new LinkedHashMap();
        Iterable iterable = form.getControls();
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Control it = (Control)element$iv$iv;
            boolean bl = false;
            if (it instanceof RequirableControl && ((RequirableControl)it).getDisabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Control control = (Control)element$iv;
            boolean bl = false;
            Object rawValue = submission.getValues().get(control.getId());
            ControlValue controlValue = this.convertToControlValue(rawValue, control);
            processedValues.put(control.getId(), controlValue);
            List list = (List)validators.get(control.getId());
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FormValidator validator = (FormValidator)element$iv2;
                boolean bl2 = false;
                ValidationResult result = validator.validate(controlValue, control);
                if (result.isValid()) continue;
                Map map = errors;
                String string = control.getId();
                String string2 = result.getErrorMessage();
                if (string2 == null) {
                    string2 = "Invalid value";
                }
                String string3 = string2;
                map.put(string, string3);
            }
        }
        return new FormSubmissionResult(submission, processedValues, errors.isEmpty(), errors);
    }

    /*
     * WARNING - void declaration
     */
    private final ControlValue convertToControlValue(Object value, Control control) {
        ControlValue controlValue;
        if (value == null) {
            return ControlValue.EmptyValue.INSTANCE;
        }
        Control control2 = control;
        if (control2 instanceof TextField || control2 instanceof TextArea) {
            controlValue = new ControlValue.TextValue(value.toString());
        } else if (control2 instanceof Checkbox || control2 instanceof Toggle) {
            controlValue = new ControlValue.BooleanValue((Boolean)value);
        } else if (control2 instanceof Slider) {
            controlValue = new ControlValue.NumberValue((Double)value);
        } else if (control2 instanceof DatePicker) {
            ControlValue.DateValue dateValue;
            if (value instanceof LocalDate) {
                dateValue = new ControlValue.DateValue((LocalDate)value);
            } else {
                LocalDate localDate = LocalDate.parse(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
                dateValue = new ControlValue.DateValue(localDate);
            }
            controlValue = dateValue;
        } else if (control2 instanceof TimePicker) {
            ControlValue.TimeValue timeValue;
            if (value instanceof LocalTime) {
                timeValue = new ControlValue.TimeValue((LocalTime)value);
            } else {
                LocalTime localTime = LocalTime.parse(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"parse(...)");
                timeValue = new ControlValue.TimeValue(localTime);
            }
            controlValue = timeValue;
        } else if (control2 instanceof Dropdown) {
            controlValue = new ControlValue.OptionValue(value.toString());
        } else if (control2 instanceof RadioGroup) {
            controlValue = new ControlValue.OptionValue(value.toString());
        } else if (control2 instanceof FileUpload) {
            if (value instanceof Map) {
                List list;
                List list2;
                Iterable<String> iterable;
                Iterable<String> destination$iv$iv;
                Object v = ((Map)value).get("ids");
                List list3 = v instanceof List ? (List)v : null;
                if (list3 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list3;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Object item$iv$iv;
                        Object t = item$iv$iv = iterator.next();
                        iterable = destination$iv$iv;
                        boolean bl = false;
                        iterable.add(String.valueOf(it));
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                List fileIds = list2;
                Object v2 = ((Map)value).get("names");
                List list4 = v2 instanceof List ? (List)v2 : null;
                if (list4 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list4;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Object item$iv$iv;
                        Object bl = item$iv$iv = iterator.next();
                        iterable = destination$iv$iv2;
                        boolean bl2 = false;
                        iterable.add((String)String.valueOf(it));
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List fileNames = list;
                controlValue = new ControlValue.FileValue(fileIds, fileNames);
            } else {
                controlValue = ControlValue.EmptyValue.INSTANCE;
            }
        } else if (control2 instanceof Button) {
            controlValue = ControlValue.EmptyValue.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return controlValue;
    }
}

