/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.mcp;

import com.embabel.agent.api.tool.MatryoshkaTool;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.spi.support.springai.SpringToolCallbackAdapterKt;
import io.modelcontextprotocol.client.McpSyncClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.SyncMcpToolCallbackProvider;
import org.springframework.ai.tool.ToolCallback;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J6\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0007J0\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0007J0\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0007J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fJ0\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/embabel/agent/tools/mcp/McpToolFactory;", "", "clients", "", "Lio/modelcontextprotocol/client/McpSyncClient;", "<init>", "(Ljava/util/List;)V", "logger", "Lorg/slf4j/Logger;", "matryoshka", "Lcom/embabel/agent/api/tool/MatryoshkaTool;", "name", "", "description", "filter", "Lkotlin/Function1;", "Lorg/springframework/ai/tool/ToolCallback;", "", "removeOnInvoke", "matryoshkaMatching", "patterns", "Lkotlin/text/Regex;", "matryoshkaByName", "toolNames", "", "toolByName", "Lcom/embabel/agent/api/tool/Tool;", "toolName", "requiredToolByName", "loadTools", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nMcpToolFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpToolFactory.kt\ncom/embabel/agent/tools/mcp/McpToolFactory\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,201:1\n27#2:202\n1557#3:203\n1628#3,3:204\n1557#3:207\n1628#3,3:208\n1557#3:214\n1628#3,3:215\n1755#3,3:218\n3829#4:211\n4344#4,2:212\n*S KotlinDebug\n*F\n+ 1 McpToolFactory.kt\ncom/embabel/agent/tools/mcp/McpToolFactory\n*L\n69#1:202\n91#1:203\n91#1:204,3\n179#1:207\n179#1:208,3\n192#1:214\n192#1:215,3\n120#1:218,3\n191#1:211\n191#1:212,2\n*E\n"})
public final class McpToolFactory {
    @NotNull
    private final List<McpSyncClient> clients;
    @NotNull
    private final Logger logger;

    public McpToolFactory(@NotNull List<? extends McpSyncClient> clients) {
        Intrinsics.checkNotNullParameter(clients, (String)"clients");
        this.clients = clients;
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(McpToolFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final MatryoshkaTool matryoshka(@NotNull String name, @NotNull String description, @NotNull Function1<? super ToolCallback, Boolean> filter, boolean removeOnInvoke) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        List<Tool> innerTools = this.loadTools(this.clients, filter);
        Object[] objectArray = new Object[3];
        objectArray[0] = name;
        objectArray[1] = innerTools.size();
        Iterable iterable = innerTools;
        int n = 2;
        Object[] objectArray2 = objectArray;
        String string = "Created McpMatryoshkaTool '{}' with {} inner tools: {}";
        Logger logger = this.logger;
        boolean $i$f$map = false;
        void var9_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tool tool = (Tool)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDefinition().getName());
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = collection;
        logger.debug(string, objectArray);
        return MatryoshkaTool.Companion.of(name, description, innerTools, removeOnInvoke);
    }

    public static /* synthetic */ MatryoshkaTool matryoshka$default(McpToolFactory mcpToolFactory, String string, String string2, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return mcpToolFactory.matryoshka(string, string2, (Function1<? super ToolCallback, Boolean>)function1, bl);
    }

    @JvmOverloads
    @NotNull
    public final MatryoshkaTool matryoshkaMatching(@NotNull String name, @NotNull String description, @NotNull List<Regex> patterns, boolean removeOnInvoke) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        return this.matryoshka(name, description, (Function1<? super ToolCallback, Boolean>)((Function1)arg_0 -> McpToolFactory.matryoshkaMatching$lambda$2(patterns, arg_0)), removeOnInvoke);
    }

    public static /* synthetic */ MatryoshkaTool matryoshkaMatching$default(McpToolFactory mcpToolFactory, String string, String string2, List list, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return mcpToolFactory.matryoshkaMatching(string, string2, list, bl);
    }

    @JvmOverloads
    @NotNull
    public final MatryoshkaTool matryoshkaByName(@NotNull String name, @NotNull String description, @NotNull Set<String> toolNames, boolean removeOnInvoke) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(toolNames, (String)"toolNames");
        return this.matryoshka(name, description, (Function1<? super ToolCallback, Boolean>)((Function1)arg_0 -> McpToolFactory.matryoshkaByName$lambda$3(toolNames, arg_0)), removeOnInvoke);
    }

    public static /* synthetic */ MatryoshkaTool matryoshkaByName$default(McpToolFactory mcpToolFactory, String string, String string2, Set set, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return mcpToolFactory.matryoshkaByName(string, string2, set, bl);
    }

    @Nullable
    public final Tool toolByName(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        List<Tool> tools = this.loadTools(this.clients, (Function1<? super ToolCallback, Boolean>)((Function1)arg_0 -> McpToolFactory.toolByName$lambda$4(toolName, arg_0)));
        Object object = CollectionsKt.firstOrNull(tools);
        Tool it = (Tool)object;
        boolean bl = false;
        if (it == null) {
            this.logger.warn("MCP tool '{}' not found", (Object)toolName);
        }
        return (Tool)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Tool requiredToolByName(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Tool tool = this.toolByName(toolName);
        if (tool == null) {
            StringBuilder stringBuilder;
            StringBuilder $this$requiredToolByName_u24lambda_u248 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$requiredToolByName_u24lambda_u248.append("MCP tool '" + toolName + "' not found.");
            List<Tool> availableTools = this.loadTools(this.clients, (Function1<? super ToolCallback, Boolean>)((Function1)McpToolFactory::requiredToolByName$lambda$8$lambda$6));
            if (availableTools.isEmpty()) {
                v1 = $this$requiredToolByName_u24lambda_u248.append(" No MCP tools are available - check MCP client connections.");
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = availableTools;
                StringBuilder stringBuilder2 = $this$requiredToolByName_u24lambda_u248;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Tool tool2 = (Tool)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getDefinition().getName());
                }
                v1 = stringBuilder2.append(" Available tools: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            String string = stringBuilder.toString();
            throw new IllegalArgumentException(string);
        }
        return tool;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tool> loadTools(List<? extends McpSyncClient> clients, Function1<? super ToolCallback, Boolean> filter) {
        List list;
        try {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            SyncMcpToolCallbackProvider provider = new SyncMcpToolCallbackProvider(clients);
            ToolCallback[] toolCallbackArray = provider.getToolCallbacks();
            Intrinsics.checkNotNullExpressionValue((Object)toolCallbackArray, (String)"getToolCallbacks(...)");
            Object[] $this$filter$iv = toolCallbackArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)filter.invoke((Object)element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredCallbacks = (List)destination$iv$iv;
            Iterable $this$map$iv = filteredCallbacks;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ToolCallback toolCallback = (ToolCallback)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(SpringToolCallbackAdapterKt.toEmbabelTool((ToolCallback)it));
            }
            List nativeTools = (List)destination$iv$iv2;
            this.logger.debug("Loaded {} MCP tools", (Object)nativeTools.size());
            list = nativeTools;
        }
        catch (Exception e) {
            this.logger.error("Failed to load MCP tools: {}", (Object)e.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmOverloads
    @NotNull
    public final MatryoshkaTool matryoshka(@NotNull String name, @NotNull String description, @NotNull Function1<? super ToolCallback, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return McpToolFactory.matryoshka$default(this, name, description, filter, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final MatryoshkaTool matryoshkaMatching(@NotNull String name, @NotNull String description, @NotNull List<Regex> patterns) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        return McpToolFactory.matryoshkaMatching$default(this, name, description, patterns, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final MatryoshkaTool matryoshkaByName(@NotNull String name, @NotNull String description, @NotNull Set<String> toolNames) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(toolNames, (String)"toolNames");
        return McpToolFactory.matryoshkaByName$default(this, name, description, toolNames, false, 8, null);
    }

    private static final boolean matryoshkaMatching$lambda$2(List $patterns, ToolCallback callback) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            String string = callback.getToolDefinition().name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            String toolName = string;
            Iterable $this$any$iv = $patterns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex pattern = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!pattern.containsMatchIn((CharSequence)toolName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean matryoshkaByName$lambda$3(Set $toolNames, ToolCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return $toolNames.contains(callback.getToolDefinition().name());
    }

    private static final boolean toolByName$lambda$4(String $toolName, ToolCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return Intrinsics.areEqual((Object)callback.getToolDefinition().name(), (Object)$toolName);
    }

    private static final boolean requiredToolByName$lambda$8$lambda$6(ToolCallback it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

