/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.math;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.api.common.support.SelfToolGroup;
import com.embabel.agent.core.CoreToolGroups;
import com.embabel.agent.core.ToolGroupDescription;
import com.embabel.agent.core.ToolGroupPermission;
import com.embabel.common.core.types.Semver;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0007J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0007J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0007J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0007J\u0016\u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0007J\u0016\u0010\u001f\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0007J\u0016\u0010 \u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0007J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0007J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0007J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/embabel/agent/tools/math/MathTools;", "Lcom/embabel/agent/api/common/support/SelfToolGroup;", "<init>", "()V", "description", "Lcom/embabel/agent/core/ToolGroupDescription;", "getDescription", "()Lcom/embabel/agent/core/ToolGroupDescription;", "provider", "", "getProvider", "()Ljava/lang/String;", "version", "Lcom/embabel/common/core/types/Semver;", "getVersion-Id9oKnY", "Ljava/lang/String;", "permissions", "", "Lcom/embabel/agent/core/ToolGroupPermission;", "getPermissions", "()Ljava/util/Set;", "add", "", "a", "b", "subtract", "multiply", "divide", "mean", "numbers", "", "min", "max", "floor", "number", "ceiling", "round", "embabel-agent-api"})
public final class MathTools
implements SelfToolGroup {
    @NotNull
    private final ToolGroupDescription description = CoreToolGroups.INSTANCE.getMATH_DESCRIPTION();
    @NotNull
    private final String provider;
    @NotNull
    private final String version = Semver.constructor-impl((int)0, (int)1, (int)0);

    public MathTools() {
        this.provider = "embabel";
    }

    @Override
    @NotNull
    public ToolGroupDescription getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getProvider() {
        return this.provider;
    }

    @Override
    @NotNull
    public String getVersion-Id9oKnY() {
        return this.version;
    }

    @Override
    @NotNull
    public Set<ToolGroupPermission> getPermissions() {
        return SetsKt.emptySet();
    }

    @LlmTool(description="add two numbers")
    public final double add(double a, double b) {
        return a + b;
    }

    @LlmTool(description="subtract the second number from the first")
    public final double subtract(double a, double b) {
        return a - b;
    }

    @LlmTool(description="multiply two numbers")
    public final double multiply(double a, double b) {
        return a * b;
    }

    @LlmTool(description="divide the first number by the second")
    @NotNull
    public final String divide(double a, double b) {
        return b == 0.0 ? "Cannot divide by zero" : "" + a / b;
    }

    @LlmTool(description="find the mean of this list of numbers")
    public final double mean(@NotNull List<Double> numbers) {
        Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
        return numbers.isEmpty() ? 0.0 : CollectionsKt.sumOfDouble((Iterable)numbers) / (double)numbers.size();
    }

    @LlmTool(description="find the minimum value in a list of numbers")
    public final double min(@NotNull List<Double> numbers) {
        Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
        Double d = CollectionsKt.minOrNull((Iterable)numbers);
        return d != null ? d : Double.NaN;
    }

    @LlmTool(description="find the maximum value in a list of numbers")
    public final double max(@NotNull List<Double> numbers) {
        Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
        Double d = CollectionsKt.maxOrNull((Iterable)numbers);
        return d != null ? d : Double.NaN;
    }

    @LlmTool(description="round down to the nearest integer")
    public final double floor(double number) {
        return Math.floor(number);
    }

    @LlmTool(description="round up to the nearest integer")
    public final double ceiling(double number) {
        return Math.ceil(number);
    }

    @LlmTool(description="round to the nearest integer")
    public final double round(double number) {
        return Math.rint(number);
    }
}

