/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.api.annotation.support.AgentMetadataReader;
import com.embabel.agent.api.annotation.support.AgenticInfo;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentScope;
import com.embabel.agent.core.deployment.AgentScanningProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!test"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/spi/support/AgentScanningPostProcessorDelegate;", "", "agentMetadataReader", "Lcom/embabel/agent/api/annotation/support/AgentMetadataReader;", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "properties", "Lcom/embabel/agent/core/deployment/AgentScanningProperties;", "<init>", "(Lcom/embabel/agent/api/annotation/support/AgentMetadataReader;Lcom/embabel/agent/core/AgentPlatform;Lcom/embabel/agent/core/deployment/AgentScanningProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "postProcessAfterInitialization", "bean", "beanName", "", "embabel-agent-api"})
public class AgentScanningPostProcessorDelegate {
    @NotNull
    private final AgentMetadataReader agentMetadataReader;
    @NotNull
    private final AgentPlatform agentPlatform;
    @NotNull
    private final AgentScanningProperties properties;
    private final Logger logger;

    public AgentScanningPostProcessorDelegate(@NotNull AgentMetadataReader agentMetadataReader, @NotNull AgentPlatform agentPlatform, @NotNull AgentScanningProperties properties) {
        Intrinsics.checkNotNullParameter((Object)agentMetadataReader, (String)"agentMetadataReader");
        Intrinsics.checkNotNullParameter((Object)agentPlatform, (String)"agentPlatform");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.agentMetadataReader = agentMetadataReader;
        this.agentPlatform = agentPlatform;
        this.properties = properties;
        this.logger = LoggerFactory.getLogger(AgentScanningPostProcessorDelegate.class);
    }

    @Nullable
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) {
        AgentScope agentMetadata;
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        if (this.properties.getAnnotation() && (agentMetadata = this.agentMetadataReader.createAgentMetadata(bean)) != null) {
            AgenticInfo agenticInfo = new AgenticInfo(bean.getClass());
            if (!agenticInfo.agentic() || agenticInfo.noAutoScan()) {
                this.logger.debug("Classpath scanning disabled on {}: ignoring this class", (Object)bean.getClass().getName());
                return null;
            }
            this.agentPlatform.deploy(agentMetadata);
        }
        return bean;
    }
}

