/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.common;

import com.embabel.agent.core.ReplanRequestedException;
import com.embabel.agent.spi.common.RetryTemplateProvider;
import com.embabel.agent.spi.support.LlmDataBindingProperties;
import com.embabel.agent.spi.support.springai.SpringAiRetryPolicy;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/embabel/agent/spi/common/RetryProperties;", "Lcom/embabel/agent/spi/common/RetryTemplateProvider;", "backoffMillis", "", "getBackoffMillis", "()J", "backoffMultiplier", "", "getBackoffMultiplier", "()D", "backoffMaxInterval", "getBackoffMaxInterval", "retryPolicy", "Lorg/springframework/retry/RetryPolicy;", "getRetryPolicy", "()Lorg/springframework/retry/RetryPolicy;", "retryTemplate", "Lorg/springframework/retry/support/RetryTemplate;", "name", "", "embabel-agent-api"})
public interface RetryProperties
extends RetryTemplateProvider {
    public long getBackoffMillis();

    public double getBackoffMultiplier();

    public long getBackoffMaxInterval();

    @NotNull
    default public RetryPolicy getRetryPolicy() {
        return new SpringAiRetryPolicy(this.getMaxAttempts(), null, 2, null);
    }

    @Override
    @NotNull
    default public RetryTemplate retryTemplate(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RetryTemplate retryTemplate2 = RetryTemplate.builder().exponentialBackoff(Duration.ofMillis(this.getBackoffMillis()), this.getBackoffMultiplier(), Duration.ofMillis(this.getBackoffMaxInterval())).customPolicy(this.getRetryPolicy()).withListener(new RetryListener(name, this){
            final /* synthetic */ String $name;
            final /* synthetic */ RetryProperties this$0;
            {
                this.$name = $name;
                this.this$0 = $receiver;
            }

            public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(callback, (String)"callback");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                if (throwable instanceof ReplanRequestedException) {
                    return;
                }
                if (LlmDataBindingProperties.Companion.isRateLimitError(throwable)) {
                    boolean $i$f$loggerFor22 = false;
                    Logger logger = LoggerFactory.getLogger(RetryProperties.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                    Object[] $i$f$loggerFor22 = new Object[]{this.$name, context.getRetryCount(), this.this$0.getRetryPolicy().getMaxAttempts() > 0 ? Integer.valueOf(this.this$0.getRetryPolicy().getMaxAttempts()) : "unknown"};
                    logger.info("LLM invocation {} RATE LIMITED: Retry attempt {} of {}", $i$f$loggerFor22);
                    return;
                }
                boolean $i$f$loggerFor = false;
                Logger logger = LoggerFactory.getLogger(RetryProperties.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.info("Operation " + this.$name + ": Retry error. Retry count: " + context.getRetryCount(), throwable);
            }
        }).build();
        Intrinsics.checkNotNullExpressionValue((Object)retryTemplate2, (String)"build(...)");
        return retryTemplate2;
    }
}

