/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core.hitl;

import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.hitl.AbstractAwaitable;
import com.embabel.agent.core.hitl.FormResponse;
import com.embabel.agent.core.hitl.ResponseImpact;
import com.embabel.agent.core.hitl.ValidationError;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.ux.form.DefaultFormProcessor;
import com.embabel.ux.form.Form;
import com.embabel.ux.form.FormBinderKt;
import com.embabel.ux.form.FormSubmissionResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003BE\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00018\u0000\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001b\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\t\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/embabel/agent/core/hitl/FormBindingRequest;", "O", "", "Lcom/embabel/agent/core/hitl/AbstractAwaitable;", "Lcom/embabel/ux/form/Form;", "Lcom/embabel/agent/core/hitl/FormResponse;", "form", "outputClass", "Ljava/lang/Class;", "population", "validationErrors", "", "Lcom/embabel/agent/core/hitl/ValidationError;", "persistent", "", "<init>", "(Lcom/embabel/ux/form/Form;Ljava/lang/Class;Ljava/lang/Object;Ljava/util/List;Z)V", "getOutputClass", "()Ljava/lang/Class;", "getPopulation", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValidationErrors", "()Ljava/util/List;", "logger", "Lorg/slf4j/Logger;", "onResponse", "Lcom/embabel/agent/core/hitl/ResponseImpact;", "response", "agentProcess", "Lcom/embabel/agent/core/AgentProcess;", "bind", "boundInstance", "(Ljava/lang/Object;Lcom/embabel/agent/core/AgentProcess;)Lcom/embabel/agent/core/hitl/ResponseImpact;", "toString", "", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nFormBindingRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormBindingRequest.kt\ncom/embabel/agent/core/hitl/FormBindingRequest\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,89:1\n27#2:90\n*S KotlinDebug\n*F\n+ 1 FormBindingRequest.kt\ncom/embabel/agent/core/hitl/FormBindingRequest\n*L\n50#1:90\n*E\n"})
public final class FormBindingRequest<O>
extends AbstractAwaitable<Form, FormResponse> {
    @NotNull
    private final Class<O> outputClass;
    @Nullable
    private final O population;
    @NotNull
    private final List<ValidationError> validationErrors;
    @NotNull
    private final Logger logger;

    @JvmOverloads
    public FormBindingRequest(@NotNull Form form, @NotNull Class<O> outputClass, @Nullable O population, @NotNull List<? extends ValidationError> validationErrors, boolean persistent) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        Intrinsics.checkNotNullParameter(validationErrors, (String)"validationErrors");
        super(form, null, null, persistent, 6, null);
        this.outputClass = outputClass;
        this.population = population;
        this.validationErrors = validationErrors;
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(FormBindingRequest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public /* synthetic */ FormBindingRequest(Form form, Class clazz, Object object, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(form, clazz, object, list, bl);
    }

    @NotNull
    public final Class<O> getOutputClass() {
        return this.outputClass;
    }

    @Nullable
    public final O getPopulation() {
        return this.population;
    }

    @NotNull
    public final List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    @Override
    @NotNull
    public ResponseImpact onResponse(@NotNull FormResponse response, @NotNull AgentProcess agentProcess) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        FormSubmissionResult formSubmissionResult = new DefaultFormProcessor().processSubmission((Form)this.getPayload(), response.getFormSubmission());
        if (!formSubmissionResult.getValid()) {
            throw new IllegalStateException("Form submission is not valid: " + formSubmissionResult.getValidationErrors());
        }
        O boundInstance = FormBinderKt.bindTo(formSubmissionResult, this.outputClass);
        return this.bind(boundInstance, agentProcess);
    }

    @NotNull
    public final ResponseImpact bind(@NotNull O boundInstance, @NotNull AgentProcess agentProcess) {
        Intrinsics.checkNotNullParameter(boundInstance, (String)"boundInstance");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        this.logger.info("Bound form submission to {}", boundInstance);
        agentProcess.plusAssign(boundInstance);
        return ResponseImpact.UPDATED;
    }

    @NotNull
    public String toString() {
        return HasInfoString.infoString$default((HasInfoString)this, (Boolean)false, (int)0, (int)2, null);
    }

    @JvmOverloads
    public FormBindingRequest(@NotNull Form form, @NotNull Class<O> outputClass, @Nullable O population, @NotNull List<? extends ValidationError> validationErrors) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        Intrinsics.checkNotNullParameter(validationErrors, (String)"validationErrors");
        this(form, outputClass, population, validationErrors, false, 16, null);
    }

    @JvmOverloads
    public FormBindingRequest(@NotNull Form form, @NotNull Class<O> outputClass, @Nullable O population) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        this(form, outputClass, population, null, false, 24, null);
    }

    @JvmOverloads
    public FormBindingRequest(@NotNull Form form, @NotNull Class<O> outputClass) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        this(form, outputClass, null, null, false, 28, null);
    }
}

