/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common;

import com.embabel.agent.api.common.Ai;
import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.api.common.PromptRunner;
import com.embabel.agent.prompt.persona.Instruction;
import com.embabel.common.ai.model.LlmOptions;
import com.embabel.common.ai.prompt.PromptContribution;
import com.embabel.common.ai.prompt.PromptContributionLocation;
import com.embabel.common.ai.prompt.PromptContributor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.validation.annotation.Validated;

@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB)\b\u0017\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\t\u0010\u001b\u001a\u00020\bH\u0096\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u0096\u0001R\u0016\u0010\u0003\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u001e\u001a\u00020\u001f8WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010\b8WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/embabel/agent/api/common/Actor;", "T", "Lcom/embabel/common/ai/prompt/PromptContributor;", "persona", "llm", "Lcom/embabel/common/ai/model/LlmOptions;", "toolGroups", "", "", "<init>", "(Lcom/embabel/common/ai/prompt/PromptContributor;Lcom/embabel/common/ai/model/LlmOptions;Ljava/util/Set;)V", "instruction", "(Ljava/lang/String;Lcom/embabel/common/ai/model/LlmOptions;Ljava/util/Set;)V", "getPersona", "()Lcom/embabel/common/ai/prompt/PromptContributor;", "Lcom/embabel/common/ai/prompt/PromptContributor;", "getLlm", "()Lcom/embabel/common/ai/model/LlmOptions;", "getToolGroups", "()Ljava/util/Set;", "promptRunner", "Lcom/embabel/agent/api/common/PromptRunner;", "ai", "Lcom/embabel/agent/api/common/Ai;", "context", "Lcom/embabel/agent/api/common/OperationContext;", "toString", "contribution", "promptContribution", "Lcom/embabel/common/ai/prompt/PromptContribution;", "promptContributionLocation", "Lcom/embabel/common/ai/prompt/PromptContributionLocation;", "getPromptContributionLocation", "()Lcom/embabel/common/ai/prompt/PromptContributionLocation;", "role", "getRole", "()Ljava/lang/String;", "embabel-agent-api"})
public class Actor<T extends PromptContributor>
implements PromptContributor {
    @NotNull
    private final T persona;
    @NotNull
    private final LlmOptions llm;
    @NotNull
    private final Set<String> toolGroups;

    @JvmOverloads
    public Actor(@NotNull T persona, @NotNull LlmOptions llm, @NotNull Set<String> toolGroups) {
        Intrinsics.checkNotNullParameter(persona, (String)"persona");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        Intrinsics.checkNotNullParameter(toolGroups, (String)"toolGroups");
        this.persona = persona;
        this.llm = llm;
        this.toolGroups = toolGroups;
    }

    public /* synthetic */ Actor(PromptContributor promptContributor, LlmOptions llmOptions, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        this(promptContributor, llmOptions, (Set<String>)set);
    }

    @NotNull
    public T getPersona() {
        return this.persona;
    }

    @NotNull
    public LlmOptions getLlm() {
        return this.llm;
    }

    @NotNull
    public Set<String> getToolGroups() {
        return this.toolGroups;
    }

    @JvmOverloads
    public Actor(@NotNull String instruction, @NotNull LlmOptions llm, @NotNull Set<String> toolGroups) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        Intrinsics.checkNotNullParameter(toolGroups, (String)"toolGroups");
        this(new Instruction(instruction), llm, toolGroups);
    }

    public /* synthetic */ Actor(String string, LlmOptions llmOptions, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        this(string, llmOptions, (Set<String>)set);
    }

    @NotNull
    public PromptRunner promptRunner(@NotNull Ai ai) {
        Intrinsics.checkNotNullParameter((Object)ai, (String)"ai");
        return ai.withLlm(this.getLlm()).withPromptContributor((PromptContributor)this.getPersona()).withToolGroups(this.getToolGroups()).withToolObject(this);
    }

    @NotNull
    public PromptRunner promptRunner(@NotNull OperationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.promptRunner(context.ai());
    }

    @NotNull
    public String toString() {
        return "Actor(persona=" + this.getPersona() + ", llm=" + this.getLlm() + ", toolGroups=" + this.getToolGroups() + ")";
    }

    @NotNull
    public PromptContribution promptContribution() {
        return this.persona.promptContribution();
    }

    @NotNull
    public String contribution() {
        return this.persona.contribution();
    }

    @JsonIgnore
    @Nullable
    public String getRole() {
        return this.persona.getRole();
    }

    @JsonIgnore
    @NotNull
    public PromptContributionLocation getPromptContributionLocation() {
        return this.persona.getPromptContributionLocation();
    }

    @JvmOverloads
    public Actor(@NotNull T persona, @NotNull LlmOptions llm) {
        Intrinsics.checkNotNullParameter(persona, (String)"persona");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        this((PromptContributor)persona, llm, null, 4, null);
    }

    @JvmOverloads
    public Actor(@NotNull String instruction, @NotNull LlmOptions llm) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        this(instruction, llm, null, 4, null);
    }
}

