/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.agent;

import com.embabel.agent.api.common.ToolObject;
import com.embabel.agent.api.common.autonomy.Autonomy;
import com.embabel.agent.api.event.AgenticEventListener;
import com.embabel.agent.core.Goal;
import com.embabel.agent.core.support.SpringAiUtilsKt;
import com.embabel.agent.tools.agent.ApplicationNameGoalToolNamingStrategy;
import com.embabel.agent.tools.agent.DefaultProcessCallbackTools;
import com.embabel.agent.tools.agent.GoalToolCallback;
import com.embabel.agent.tools.agent.GoalToolNamingStrategy;
import com.embabel.agent.tools.agent.PromptedTextCommunicator;
import com.embabel.agent.tools.agent.TextCommunicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00112\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011J&\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/embabel/agent/tools/agent/PerGoalToolCallbackFactory;", "", "autonomy", "Lcom/embabel/agent/api/common/autonomy/Autonomy;", "applicationName", "", "textCommunicator", "Lcom/embabel/agent/tools/agent/TextCommunicator;", "goalToolNamingStrategy", "Lcom/embabel/agent/tools/agent/GoalToolNamingStrategy;", "<init>", "(Lcom/embabel/agent/api/common/autonomy/Autonomy;Ljava/lang/String;Lcom/embabel/agent/tools/agent/TextCommunicator;Lcom/embabel/agent/tools/agent/GoalToolNamingStrategy;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "platformTools", "", "Lorg/springframework/ai/tool/ToolCallback;", "getPlatformTools", "()Ljava/util/List;", "goalTools", "Lcom/embabel/agent/tools/agent/GoalToolCallback;", "remoteOnly", "", "listeners", "Lcom/embabel/agent/api/event/AgenticEventListener;", "toolCallbacks", "toolsForGoal", "goal", "Lcom/embabel/agent/core/Goal;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nPerGoalToolCallbackFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerGoalToolCallbackFactory.kt\ncom/embabel/agent/tools/agent/PerGoalToolCallbackFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n774#2:156\n865#2,2:157\n774#2:159\n865#2,2:160\n1368#2:162\n1454#2,5:163\n1557#2:168\n1628#2,3:169\n*S KotlinDebug\n*F\n+ 1 PerGoalToolCallbackFactory.kt\ncom/embabel/agent/tools/agent/PerGoalToolCallbackFactory\n*L\n102#1:156\n102#1:157,2\n103#1:159\n103#1:160,2\n104#1:162\n104#1:163,5\n141#1:168\n141#1:169,3\n*E\n"})
public final class PerGoalToolCallbackFactory {
    @NotNull
    private final Autonomy autonomy;
    @NotNull
    private final TextCommunicator textCommunicator;
    @NotNull
    private final GoalToolNamingStrategy goalToolNamingStrategy;
    private final Logger logger;
    @NotNull
    private final List<ToolCallback> platformTools;

    public PerGoalToolCallbackFactory(@NotNull Autonomy autonomy, @NotNull String applicationName, @NotNull TextCommunicator textCommunicator, @NotNull GoalToolNamingStrategy goalToolNamingStrategy) {
        Intrinsics.checkNotNullParameter((Object)autonomy, (String)"autonomy");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)textCommunicator, (String)"textCommunicator");
        Intrinsics.checkNotNullParameter((Object)goalToolNamingStrategy, (String)"goalToolNamingStrategy");
        this.autonomy = autonomy;
        this.textCommunicator = textCommunicator;
        this.goalToolNamingStrategy = goalToolNamingStrategy;
        this.logger = LoggerFactory.getLogger(PerGoalToolCallbackFactory.class);
        this.platformTools = SpringAiUtilsKt.safelyGetToolCallbacksFrom(new ToolObject(new DefaultProcessCallbackTools(this.autonomy, this.textCommunicator)));
    }

    public /* synthetic */ PerGoalToolCallbackFactory(Autonomy autonomy, String string, TextCommunicator textCommunicator, GoalToolNamingStrategy goalToolNamingStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            textCommunicator = PromptedTextCommunicator.INSTANCE;
        }
        if ((n & 8) != 0) {
            goalToolNamingStrategy = new ApplicationNameGoalToolNamingStrategy(string);
        }
        this(autonomy, string, textCommunicator, goalToolNamingStrategy);
    }

    @NotNull
    public final List<ToolCallback> getPlatformTools() {
        return this.platformTools;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GoalToolCallback<?>> goalTools(boolean remoteOnly, @NotNull List<? extends AgenticEventListener> listeners) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Goal it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Iterable iterable = this.autonomy.getAgentPlatform().getGoals();
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Goal)element$iv$iv;
            boolean bl = false;
            if (!it.getExport().getLocal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Goal)element$iv$iv;
            boolean bl = false;
            if (!(!remoteOnly || it.getExport().getRemote())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Goal goal = (Goal)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.toolsForGoal(goal, listeners);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List goalTools = (List)destination$iv$iv;
        if (goalTools.isEmpty()) {
            this.logger.info("No goals found in agent platform, no tool callbacks will be published");
            return CollectionsKt.emptyList();
        }
        this.logger.info("{} goal tools found in agent platform: {}", (Object)goalTools.size(), (Object)goalTools);
        return goalTools;
    }

    @NotNull
    public final List<ToolCallback> toolCallbacks(boolean remoteOnly, @NotNull List<? extends AgenticEventListener> listeners) {
        List list;
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        List<GoalToolCallback<?>> goalTools = this.goalTools(remoteOnly, listeners);
        if (goalTools.isEmpty()) {
            this.logger.warn("No goal tools found, no tool callbacks will be published");
            list = CollectionsKt.emptyList();
        } else {
            list = CollectionsKt.plus((Collection)goalTools, (Iterable)this.platformTools);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GoalToolCallback<?>> toolsForGoal(@NotNull Goal goal, @NotNull List<? extends AgenticEventListener> listeners) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        String string = goal.getExport().getName();
        if (string == null) {
            string = this.goalToolNamingStrategy.nameForGoal(goal);
        }
        String goalName = string;
        Iterable $this$map$iv = goal.getExport().getStartingInputTypes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void inputType;
            Class clazz = (Class)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Autonomy autonomy = this.autonomy;
            String string2 = goal.getDescription();
            TextCommunicator textCommunicator = this.textCommunicator;
            collection.add(new GoalToolCallback(autonomy, textCommunicator, goalName, string2, goal, inputType, (List<? extends AgenticEventListener>)((List<AgenticEventListener>)listeners)));
        }
        return (List)destination$iv$iv;
    }
}

