/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.agent;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.api.common.autonomy.AgentProcessExecution;
import com.embabel.agent.api.common.autonomy.Autonomy;
import com.embabel.agent.api.common.autonomy.ProcessWaitingException;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.hitl.ConfirmationRequest;
import com.embabel.agent.core.hitl.ConfirmationResponse;
import com.embabel.agent.core.hitl.FormBindingRequest;
import com.embabel.agent.core.hitl.ResponseImpact;
import com.embabel.agent.spi.LlmInteraction;
import com.embabel.agent.tools.agent.TextCommunicator;
import com.embabel.common.ai.model.LlmOptions;
import com.embabel.common.ai.model.ModelSelectionCriteria;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0007J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/embabel/agent/tools/agent/DefaultProcessCallbackTools;", "", "autonomy", "Lcom/embabel/agent/api/common/autonomy/Autonomy;", "textCommunicator", "Lcom/embabel/agent/tools/agent/TextCommunicator;", "<init>", "(Lcom/embabel/agent/api/common/autonomy/Autonomy;Lcom/embabel/agent/tools/agent/TextCommunicator;)V", "getAutonomy", "()Lcom/embabel/agent/api/common/autonomy/Autonomy;", "getTextCommunicator", "()Lcom/embabel/agent/tools/agent/TextCommunicator;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "submitFormAndResumeProcess", "", "processId", "formData", "confirmation", "confirmed", "", "embabel-agent-api"})
public final class DefaultProcessCallbackTools {
    @NotNull
    private final Autonomy autonomy;
    @NotNull
    private final TextCommunicator textCommunicator;
    private final Logger logger;

    public DefaultProcessCallbackTools(@NotNull Autonomy autonomy, @NotNull TextCommunicator textCommunicator) {
        Intrinsics.checkNotNullParameter((Object)autonomy, (String)"autonomy");
        Intrinsics.checkNotNullParameter((Object)textCommunicator, (String)"textCommunicator");
        this.autonomy = autonomy;
        this.textCommunicator = textCommunicator;
        this.logger = LoggerFactory.getLogger(DefaultProcessCallbackTools.class);
    }

    @NotNull
    public final Autonomy getAutonomy() {
        return this.autonomy;
    }

    @NotNull
    public final TextCommunicator getTextCommunicator() {
        return this.textCommunicator;
    }

    @LlmTool(description="Resume a process by providing the process ID and form content", name="submitFormAndResumeProcess")
    @NotNull
    public final String submitFormAndResumeProcess(@NotNull String processId, @NotNull String formData) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)formData, (String)"formData");
        this.logger.info("Form submission tool called with processId: {}, form input: {}", (Object)processId, (Object)formData);
        AgentProcess agentProcess = this.autonomy.getAgentPlatform().getAgentProcess(processId);
        if (agentProcess == null) {
            return "No process found with ID " + processId;
        }
        AgentProcess agentProcess2 = agentProcess;
        Object object = agentProcess2.lastResult();
        FormBindingRequest formBindingRequest = object instanceof FormBindingRequest ? (FormBindingRequest)object : null;
        if (formBindingRequest == null) {
            return "No form binding request found for process " + processId;
        }
        FormBindingRequest formBindingRequest2 = formBindingRequest;
        String prompt = StringsKt.trimIndent((String)("\n            Given the content below, return the given object\n\n            # Content\n            " + formData + "\n        "));
        Object formDataObject = this.autonomy.getAgentPlatform().getPlatformServices().getLlmOperations().doTransform(prompt, LlmInteraction.Companion.using(LlmOptions.Companion.invoke(ModelSelectionCriteria.Companion.getAuto())), formBindingRequest2.getOutputClass(), null);
        ResponseImpact responseImpact = formBindingRequest2.bind(formDataObject, agentProcess2);
        if (responseImpact != ResponseImpact.UPDATED) {
            String string = "Handle unchanged response impact";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        agentProcess2.run();
        try {
            AgentProcessExecution ape = AgentProcessExecution.Companion.fromProcessStatus(formData, agentProcess2);
            return this.textCommunicator.communicateResult(ape);
        }
        catch (ProcessWaitingException pwe) {
            String response = this.textCommunicator.communicateAwaitable(agentProcess2.getAgent(), pwe);
            this.logger.info("Returning waiting response:\n" + response);
            return response;
        }
    }

    @LlmTool(description="Resume a process by providing the process ID and form content", name="_confirm")
    @NotNull
    public final String confirmation(@NotNull String processId, boolean confirmed) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        this.logger.info("Confirmation tool called with processId: {}, confirmed: {}", (Object)processId, (Object)confirmed);
        AgentProcess agentProcess = this.autonomy.getAgentPlatform().getAgentProcess(processId);
        if (agentProcess == null) {
            return "No process found with ID " + processId;
        }
        AgentProcess agentProcess2 = agentProcess;
        Object object = agentProcess2.lastResult();
        ConfirmationRequest confirmationRequest = object instanceof ConfirmationRequest ? (ConfirmationRequest)object : null;
        if (confirmationRequest == null) {
            return "No confirmation binding request found for process " + processId;
        }
        ConfirmationRequest confirmationRequest2 = confirmationRequest;
        ConfirmationResponse confirmationResponse = new ConfirmationResponse(null, confirmationRequest2.getId(), confirmed, false, null, 25, null);
        if (!confirmationResponse.getAccepted()) {
            this.logger.info("Confirmation request rejected: {}", confirmationRequest2.getPayload());
            return "Confirmation request rejected: " + confirmationRequest2.getPayload();
        }
        agentProcess2.plusAssign(confirmationRequest2.getPayload());
        agentProcess2.run();
        try {
            AgentProcessExecution ape = AgentProcessExecution.Companion.fromProcessStatus(confirmationRequest2.getPayload(), agentProcess2);
            return this.textCommunicator.communicateResult(ape);
        }
        catch (ProcessWaitingException pwe) {
            String response = this.textCommunicator.communicateAwaitable(agentProcess2.getAgent(), pwe);
            this.logger.info("Returning waiting response:\n" + response);
            return response;
        }
    }
}

