/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.chat;

import com.embabel.chat.ContentPart;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/embabel/chat/ImagePart;", "Lcom/embabel/chat/ContentPart;", "mimeType", "", "data", "", "<init>", "(Ljava/lang/String;[B)V", "getMimeType", "()Ljava/lang/String;", "getData", "()[B", "equals", "", "other", "", "hashCode", "", "component1", "component2", "copy", "toString", "Companion", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nContentPart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentPart.kt\ncom/embabel/chat/ImagePart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class ImagePart
implements ContentPart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mimeType;
    @NotNull
    private final byte[] data;
    public static final int MAX_IMAGE_SIZE = 0x1400000;
    @NotNull
    private static final Set<String> SUPPORTED_MIME_TYPES;

    public ImagePart(@NotNull String mimeType, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.mimeType = mimeType;
        this.data = data;
        if (!ImagePart.Companion.isValidImageMimeType(this.mimeType)) {
            boolean $i$a$-require-ImagePart$42 = false;
            String $i$a$-require-ImagePart$42 = "Invalid image MIME type: " + this.mimeType + ". Supported: " + CollectionsKt.joinToString$default((Iterable)SUPPORTED_MIME_TYPES, null, null, null, (int)0, null, null, (int)63, null);
            throw new IllegalArgumentException($i$a$-require-ImagePart$42.toString());
        }
        if (!(!(this.data.length == 0))) {
            boolean $i$a$-require-ImagePart$52 = false;
            String $i$a$-require-ImagePart$52 = "Image data cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ImagePart$52.toString());
        }
        if (!(this.data.length <= 0x1400000)) {
            boolean bl = false;
            String string = "Image too large: " + this.data.length + " bytes. Maximum allowed: 20971520 bytes";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ImagePart)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mimeType, (Object)((ImagePart)other).mimeType) && Arrays.equals(this.data, ((ImagePart)other).data);
    }

    public int hashCode() {
        return this.mimeType.hashCode() * 31 + Arrays.hashCode(this.data);
    }

    @NotNull
    public final String component1() {
        return this.mimeType;
    }

    @NotNull
    public final byte[] component2() {
        return this.data;
    }

    @NotNull
    public final ImagePart copy(@NotNull String mimeType, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new ImagePart(mimeType, data);
    }

    public static /* synthetic */ ImagePart copy$default(ImagePart imagePart, String string, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            string = imagePart.mimeType;
        }
        if ((n & 2) != 0) {
            byArray = imagePart.data;
        }
        return imagePart.copy(string, byArray);
    }

    @NotNull
    public String toString() {
        return "ImagePart(mimeType=" + this.mimeType + ", data=" + Arrays.toString(this.data) + ")";
    }

    static {
        Object[] objectArray = new String[]{"image/png", "image/jpeg", "image/jpg", "image/gif", "image/webp", "image/bmp"};
        SUPPORTED_MIME_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/embabel/chat/ImagePart$Companion;", "", "<init>", "()V", "MAX_IMAGE_SIZE", "", "SUPPORTED_MIME_TYPES", "", "", "getSUPPORTED_MIME_TYPES", "()Ljava/util/Set;", "isValidImageMimeType", "", "mimeType", "embabel-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getSUPPORTED_MIME_TYPES() {
            return SUPPORTED_MIME_TYPES;
        }

        private final boolean isValidImageMimeType(String mimeType) {
            Set<String> set = this.getSUPPORTED_MIME_TYPES();
            String string = mimeType.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return set.contains(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

