/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common;

import com.embabel.agent.api.common.AgentImage;
import com.embabel.agent.api.common.MultimodalContent;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u001f\u0010\u0006\u001a\u00020\u00002\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0012\"\u00020\b\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/embabel/agent/api/common/MultimodalContentBuilder;", "", "<init>", "()V", "text", "", "images", "", "Lcom/embabel/agent/api/common/AgentImage;", "content", "image", "mimeType", "data", "", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "", "([Lcom/embabel/agent/api/common/AgentImage;)Lcom/embabel/agent/api/common/MultimodalContentBuilder;", "build", "Lcom/embabel/agent/api/common/MultimodalContent;", "embabel-agent-api"})
public final class MultimodalContentBuilder {
    @NotNull
    private String text = "";
    @NotNull
    private final List<AgentImage> images = new ArrayList();

    @NotNull
    public final MultimodalContentBuilder text(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.text = content;
        return this;
    }

    @NotNull
    public final MultimodalContentBuilder image(@NotNull AgentImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.images.add(image);
        return this;
    }

    @NotNull
    public final MultimodalContentBuilder image(@NotNull String mimeType, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.images.add(new AgentImage(mimeType, data));
        return this;
    }

    @NotNull
    public final MultimodalContentBuilder image(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.images.add(AgentImage.Companion.fromFile(file));
        return this;
    }

    @NotNull
    public final MultimodalContentBuilder image(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.images.add(AgentImage.Companion.fromPath(path));
        return this;
    }

    @NotNull
    public final MultimodalContentBuilder images(AgentImage ... images) {
        Intrinsics.checkNotNullParameter((Object)images, (String)"images");
        CollectionsKt.addAll((Collection)this.images, (Object[])images);
        return this;
    }

    @NotNull
    public final MultimodalContent build() {
        return new MultimodalContent(this.text, CollectionsKt.toList((Iterable)this.images));
    }
}

