/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.annotation.support;

import com.embabel.agent.api.annotation.Agent;
import com.embabel.agent.api.annotation.EmbabelComponent;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.util.ClassUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0016J\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0003J\r\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0017\u0010\u001b\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0016H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/embabel/agent/api/annotation/support/AgenticInfo;", "", "type", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "getType", "()Ljava/lang/Class;", "targetType", "embabelComponentAnnotation", "Lcom/embabel/agent/api/annotation/EmbabelComponent;", "getEmbabelComponentAnnotation", "()Lcom/embabel/agent/api/annotation/EmbabelComponent;", "agentAnnotation", "Lcom/embabel/agent/api/annotation/Agent;", "getAgentAnnotation", "()Lcom/embabel/agent/api/annotation/Agent;", "isAgent", "", "agentic", "validationErrors", "", "", "noAutoScan", "agentName", "getTargetType", "component1", "copy", "equals", "other", "hashCode", "", "toString", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAgentMetadataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentMetadataReader.kt\ncom/embabel/agent/api/annotation/support/AgenticInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,715:1\n1#2:716\n*E\n"})
public final class AgenticInfo {
    @NotNull
    private final Class<?> type;
    @NotNull
    private final Class<?> targetType;
    @Nullable
    private final EmbabelComponent embabelComponentAnnotation;
    @Nullable
    private final Agent agentAnnotation;

    public AgenticInfo(@NotNull Class<?> type2) {
        Class clazz;
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        this.type = type2;
        if (Enhancer.isEnhanced(this.type) || Proxy.isProxyClass(this.type)) {
            Class clazz2 = ClassUtils.getUserClass(this.type);
            Intrinsics.checkNotNull((Object)clazz2);
            clazz = clazz2;
        } else {
            clazz = this.type;
        }
        this.targetType = clazz;
        this.embabelComponentAnnotation = this.targetType.getAnnotation(EmbabelComponent.class);
        this.agentAnnotation = this.targetType.getAnnotation(Agent.class);
    }

    @NotNull
    public final Class<?> getType() {
        return this.type;
    }

    @Nullable
    public final EmbabelComponent getEmbabelComponentAnnotation() {
        return this.embabelComponentAnnotation;
    }

    @Nullable
    public final Agent getAgentAnnotation() {
        return this.agentAnnotation;
    }

    public final boolean isAgent() {
        return this.agentAnnotation != null;
    }

    public final boolean agentic() {
        return this.embabelComponentAnnotation != null || this.agentAnnotation != null;
    }

    @NotNull
    public final Collection<String> validationErrors() {
        List errors = new ArrayList();
        if (this.embabelComponentAnnotation != null && this.agentAnnotation != null) {
            ((Collection)errors).add("Both @Agentic and @Agent annotations found on " + this.targetType.getName() + ". Treating class as Agent, but both should not be used");
        }
        if (this.agentAnnotation != null && StringsKt.isBlank((CharSequence)this.agentAnnotation.description())) {
            CollectionsKt.plus((Collection)errors, (Object)("No description provided for @" + Agent.class.getSimpleName() + " on " + this.targetType.getName()));
        }
        return errors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean noAutoScan() {
        boolean bl;
        EmbabelComponent embabelComponent = this.embabelComponentAnnotation;
        if (embabelComponent != null) {
            if (!embabelComponent.scan()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        Agent agent = this.agentAnnotation;
        if (agent == null) return false;
        if (agent.scan()) return false;
        return true;
    }

    @NotNull
    public final String agentName() {
        CharSequence charSequence;
        CharSequence charSequence2;
        Object object = this.agentAnnotation;
        if (object == null || (object = object.name()) == null) {
            object = "";
        }
        if (StringsKt.isBlank((CharSequence)(charSequence2 = (CharSequence)object))) {
            boolean bl = false;
            String string = this.targetType.getSimpleName();
            charSequence = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public final Class<?> getTargetType() {
        return this.targetType;
    }

    @NotNull
    public final Class<?> component1() {
        return this.type;
    }

    @NotNull
    public final AgenticInfo copy(@NotNull Class<?> type2) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        return new AgenticInfo(type2);
    }

    public static /* synthetic */ AgenticInfo copy$default(AgenticInfo agenticInfo, Class clazz, int n, Object object) {
        if ((n & 1) != 0) {
            clazz = agenticInfo.type;
        }
        return agenticInfo.copy(clazz);
    }

    @NotNull
    public String toString() {
        return "AgenticInfo(type=" + this.type + ")";
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AgenticInfo)) {
            return false;
        }
        AgenticInfo agenticInfo = (AgenticInfo)other;
        return Intrinsics.areEqual(this.type, agenticInfo.type);
    }
}

