/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.web.sse;

import com.embabel.agent.event.AgentProcessEvent;
import com.embabel.agent.event.AgenticEventListener;
import com.embabel.agent.web.sse.SseProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0012\u0010\u0014\u001a\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\fH\u0017J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000eH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/web/sse/SSEController;", "Lcom/embabel/agent/event/AgenticEventListener;", "sseProperties", "Lcom/embabel/agent/web/sse/SseProperties;", "<init>", "(Lcom/embabel/agent/web/sse/SseProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "processEmitters", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "eventBuffer", "Lcom/embabel/agent/event/AgentProcessEvent;", "onProcessEvent", "", "event", "streamEventsForId", "processId", "removeEmitter", "emitter", "Companion", "embabel-agent-api"})
public class SSEController
implements AgenticEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SseProperties sseProperties;
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<String, List<SseEmitter>> processEmitters;
    @NotNull
    private final ConcurrentHashMap<String, List<AgentProcessEvent>> eventBuffer;
    @NotNull
    public static final String SSE_EVENT_NAME = "agent-process-event";

    public SSEController(@NotNull SseProperties sseProperties) {
        Intrinsics.checkNotNullParameter((Object)sseProperties, (String)"sseProperties");
        this.sseProperties = sseProperties;
        this.logger = LoggerFactory.getLogger(SSEController.class);
        this.logger.info("SSEController initialized, ready to stream AgentProcessEvents...");
        this.processEmitters = new ConcurrentHashMap();
        this.eventBuffer = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProcessEvent(@NotNull AgentProcessEvent event) {
        block9: {
            List<SseEmitter> emitters;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            String processId = event.getProcessId();
            ConcurrentHashMap<String, List<AgentProcessEvent>> concurrentHashMap = this.eventBuffer;
            synchronized (concurrentHashMap) {
                boolean bl = false;
                List<AgentProcessEvent> list = this.eventBuffer.remove(processId);
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList());
                }
                List<AgentProcessEvent> buffer = list;
                Intrinsics.checkNotNull(buffer);
                List<AgentProcessEvent> list2 = buffer;
                synchronized (list2) {
                    boolean bl2 = false;
                    buffer.add(event);
                    if (buffer.size() > this.sseProperties.getMaxBufferSize()) {
                        buffer.remove(0);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                ((Map)this.eventBuffer).put(processId, buffer);
                if (this.eventBuffer.size() > this.sseProperties.getMaxProcessBuffers()) {
                    Set set = this.eventBuffer.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                    String oldestProcessId = (String)CollectionsKt.first((Iterable)set);
                    this.eventBuffer.remove(oldestProcessId);
                    this.logger.debug("Evicted oldest process buffer: {}", (Object)oldestProcessId);
                }
                Unit unit = Unit.INSTANCE;
            }
            List<SseEmitter> list = emitters = this.processEmitters.get(processId);
            if (list == null) break block9;
            list.removeIf(arg_0 -> SSEController.onProcessEvent$lambda$3(arg_0 -> SSEController.onProcessEvent$lambda$2(this, processId, event, arg_0), arg_0));
        }
    }

    @GetMapping(value={"/events/process/{processId}"}, produces={"text/event-stream"})
    @NotNull
    public SseEmitter streamEventsForId(@PathVariable @NotNull String processId) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        SseEmitter emitter = new SseEmitter(Long.valueOf(Long.MAX_VALUE));
        this.logger.debug("SSE streaming active for process {}", (Object)processId);
        this.processEmitters.computeIfAbsent(processId, arg_0 -> SSEController.streamEventsForId$lambda$5(SSEController::streamEventsForId$lambda$4, arg_0)).add(emitter);
        emitter.onCompletion(() -> SSEController.streamEventsForId$lambda$6(this, processId, emitter));
        emitter.onTimeout(() -> SSEController.streamEventsForId$lambda$7(this, processId, emitter));
        emitter.onError(arg_0 -> SSEController.streamEventsForId$lambda$8(this, processId, emitter, arg_0));
        try {
            List<AgentProcessEvent> list = this.eventBuffer.get(processId);
            if (list != null) {
                List<AgentProcessEvent> buffer = list;
                boolean bl = false;
                for (AgentProcessEvent event : buffer) {
                    this.logger.debug("Catchup: Sending buffered event for process {}: {}", (Object)processId, (Object)event);
                    emitter.send(SseEmitter.event().name(SSE_EVENT_NAME).data((Object)event));
                }
            }
            emitter.send(SseEmitter.event().name("connected").data((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Connected to stream for process ID: " + processId)))));
        }
        catch (Exception e) {
            emitter.completeWithError((Throwable)e);
        }
        return emitter;
    }

    private void removeEmitter(String processId, SseEmitter emitter) {
        List<SseEmitter> list = this.processEmitters.get(processId);
        if (list != null) {
            list.remove(emitter);
        }
        List<SseEmitter> list2 = this.processEmitters.get(processId);
        boolean bl = list2 != null ? list2.isEmpty() : false;
        if (bl) {
            this.processEmitters.remove(processId);
        }
    }

    private static final boolean onProcessEvent$lambda$2(SSEController this$0, String $processId, AgentProcessEvent $event, SseEmitter emitter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        try {
            this$0.logger.debug("Sending SSE event for process {}: {}", (Object)$processId, (Object)$event);
            emitter.send(SseEmitter.event().name(SSE_EVENT_NAME).data((Object)$event));
            bl = false;
        }
        catch (IOException iOException) {
            this$0.logger.debug("Disconnecting emitter for process {}", (Object)$processId);
            bl = true;
        }
        catch (Throwable t) {
            this$0.logger.warn("Error sending event to emitter for process " + $processId, t);
            bl = true;
        }
        return bl;
    }

    private static final boolean onProcessEvent$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List streamEventsForId$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Collections.synchronizedList(new ArrayList());
    }

    private static final List streamEventsForId$lambda$5(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final void streamEventsForId$lambda$6(SSEController this$0, String $processId, SseEmitter $emitter) {
        this$0.removeEmitter($processId, $emitter);
    }

    private static final void streamEventsForId$lambda$7(SSEController this$0, String $processId, SseEmitter $emitter) {
        this$0.removeEmitter($processId, $emitter);
    }

    private static final void streamEventsForId$lambda$8(SSEController this$0, String $processId, SseEmitter $emitter, Throwable it) {
        this$0.removeEmitter($processId, $emitter);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/embabel/agent/web/sse/SSEController$Companion;", "", "<init>", "()V", "SSE_EVENT_NAME", "", "embabel-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

