/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.agent;

import com.embabel.agent.api.common.autonomy.AgentProcessExecution;
import com.embabel.agent.api.common.autonomy.Autonomy;
import com.embabel.agent.api.common.autonomy.ProcessWaitingException;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.Goal;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.agent.core.Verbosity;
import com.embabel.agent.event.AgenticEventListener;
import com.embabel.agent.tools.agent.TextCommunicator;
import com.embabel.agent.tools.agent.TypeWrappingToolDefinition;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BO\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010(\u001a\u00020\u0011J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tH\u0016J\u001a\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020\tH\u0016J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0007H\u00c6\u0003J\t\u00102\u001a\u00020\tH\u00c6\u0003J\t\u00103\u001a\u00020\tH\u00c6\u0003J\t\u00104\u001a\u00020\fH\u00c6\u0003J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u00c6\u0003J\u000f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u00c6\u0003Ja\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u00c6\u0001J\u0013\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010;\u001a\u00020<H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/embabel/agent/tools/agent/GoalToolCallback;", "I", "", "Lorg/springframework/ai/tool/ToolCallback;", "autonomy", "Lcom/embabel/agent/api/common/autonomy/Autonomy;", "textCommunicator", "Lcom/embabel/agent/tools/agent/TextCommunicator;", "name", "", "description", "goal", "Lcom/embabel/agent/core/Goal;", "inputType", "Ljava/lang/Class;", "listeners", "", "Lcom/embabel/agent/event/AgenticEventListener;", "<init>", "(Lcom/embabel/agent/api/common/autonomy/Autonomy;Lcom/embabel/agent/tools/agent/TextCommunicator;Ljava/lang/String;Ljava/lang/String;Lcom/embabel/agent/core/Goal;Ljava/lang/Class;Ljava/util/List;)V", "getAutonomy", "()Lcom/embabel/agent/api/common/autonomy/Autonomy;", "getTextCommunicator", "()Lcom/embabel/agent/tools/agent/TextCommunicator;", "getName", "()Ljava/lang/String;", "getDescription", "getGoal", "()Lcom/embabel/agent/core/Goal;", "getInputType", "()Ljava/lang/Class;", "getListeners", "()Ljava/util/List;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "withListener", "listener", "getToolDefinition", "Lorg/springframework/ai/tool/definition/ToolDefinition;", "call", "toolInput", "toolContext", "Lorg/springframework/ai/chat/model/ToolContext;", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "embabel-agent-api"})
public final class GoalToolCallback<I>
implements ToolCallback {
    @NotNull
    private final Autonomy autonomy;
    @NotNull
    private final TextCommunicator textCommunicator;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final Goal goal;
    @NotNull
    private final Class<I> inputType;
    @NotNull
    private final List<AgenticEventListener> listeners;
    private final Logger logger;
    @NotNull
    private final ObjectMapper objectMapper;

    public GoalToolCallback(@NotNull Autonomy autonomy, @NotNull TextCommunicator textCommunicator, @NotNull String name, @NotNull String description, @NotNull Goal goal, @NotNull Class<I> inputType, @NotNull List<? extends AgenticEventListener> listeners) {
        Intrinsics.checkNotNullParameter((Object)autonomy, (String)"autonomy");
        Intrinsics.checkNotNullParameter((Object)textCommunicator, (String)"textCommunicator");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter(inputType, (String)"inputType");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        this.autonomy = autonomy;
        this.textCommunicator = textCommunicator;
        this.name = name;
        this.description = description;
        this.goal = goal;
        this.inputType = inputType;
        this.listeners = listeners;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.objectMapper = this.autonomy.getAgentPlatform().getPlatformServices().getObjectMapper();
    }

    public /* synthetic */ GoalToolCallback(Autonomy autonomy, TextCommunicator textCommunicator, String string, String string2, Goal goal, Class clazz, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = goal.getDescription();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(autonomy, textCommunicator, string, string2, goal, clazz, list);
    }

    @NotNull
    public final Autonomy getAutonomy() {
        return this.autonomy;
    }

    @NotNull
    public final TextCommunicator getTextCommunicator() {
        return this.textCommunicator;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final Goal getGoal() {
        return this.goal;
    }

    @NotNull
    public final Class<I> getInputType() {
        return this.inputType;
    }

    @NotNull
    public final List<AgenticEventListener> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final GoalToolCallback<I> withListener(@NotNull AgenticEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return GoalToolCallback.copy$default(this, null, null, null, null, null, null, CollectionsKt.plus((Collection)this.listeners, (Object)listener), 63, null);
    }

    @NotNull
    public ToolDefinition getToolDefinition() {
        return new TypeWrappingToolDefinition(this.name, this.description, this.inputType);
    }

    @NotNull
    public String call(@NotNull String toolInput) {
        Intrinsics.checkNotNullParameter((Object)toolInput, (String)"toolInput");
        return this.call(toolInput, null);
    }

    @NotNull
    public String call(@NotNull String toolInput, @Nullable ToolContext toolContext) {
        Object o;
        Intrinsics.checkNotNullParameter((Object)toolInput, (String)"toolInput");
        this.logger.info("Calling tool {} with input {}", (Object)this.name, (Object)toolInput);
        Verbosity verbosity = new Verbosity(true, false, false, false, 14, null);
        try {
            o = this.objectMapper.readValue(toolInput, this.inputType);
            this.logger.info("Successfully parsed tool input to an instance of {}:\n{}", (Object)o.getClass().getName(), o);
        }
        catch (Exception e) {
            String errorReturn = "BAD INPUT ERROR parsing tool input: " + e.getMessage() + ": Try again and see if you can get the format right";
            this.logger.warn("Error " + errorReturn + " parsing tool input: " + toolInput, (Throwable)e);
            return errorReturn;
        }
        Object inputObject = o;
        ProcessOptions processOptions = new ProcessOptions(null, null, null, verbosity, null, null, false, this.listeners, null, 375, null);
        Autonomy errorReturn = this.autonomy;
        Intrinsics.checkNotNull((Object)inputObject);
        Object object = inputObject;
        Goal goal = this.goal;
        AgentPlatform agentPlatform = this.autonomy.getAgentPlatform();
        Agent agent = errorReturn.createGoalAgent(object, agentPlatform, goal, false);
        try {
            AgentProcessExecution agentProcessExecution = this.autonomy.runAgent(inputObject, processOptions, agent);
            this.logger.info("Goal response: {}", (Object)agentProcessExecution);
            return this.textCommunicator.communicateResult(agentProcessExecution);
        }
        catch (ProcessWaitingException pwe) {
            String response = this.textCommunicator.communicateAwaitable(this.goal, pwe);
            this.logger.info("Returning waiting response:\n" + response);
            return response;
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(goal=" + this.goal.getName() + ", description=" + this.goal.getDescription() + ")";
    }

    @NotNull
    public final Autonomy component1() {
        return this.autonomy;
    }

    @NotNull
    public final TextCommunicator component2() {
        return this.textCommunicator;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final String component4() {
        return this.description;
    }

    @NotNull
    public final Goal component5() {
        return this.goal;
    }

    @NotNull
    public final Class<I> component6() {
        return this.inputType;
    }

    @NotNull
    public final List<AgenticEventListener> component7() {
        return this.listeners;
    }

    @NotNull
    public final GoalToolCallback<I> copy(@NotNull Autonomy autonomy, @NotNull TextCommunicator textCommunicator, @NotNull String name, @NotNull String description, @NotNull Goal goal, @NotNull Class<I> inputType, @NotNull List<? extends AgenticEventListener> listeners) {
        Intrinsics.checkNotNullParameter((Object)autonomy, (String)"autonomy");
        Intrinsics.checkNotNullParameter((Object)textCommunicator, (String)"textCommunicator");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter(inputType, (String)"inputType");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        return new GoalToolCallback<I>(autonomy, textCommunicator, name, description, goal, inputType, listeners);
    }

    public static /* synthetic */ GoalToolCallback copy$default(GoalToolCallback goalToolCallback, Autonomy autonomy, TextCommunicator textCommunicator, String string, String string2, Goal goal, Class clazz, List list, int n, Object object) {
        if ((n & 1) != 0) {
            autonomy = goalToolCallback.autonomy;
        }
        if ((n & 2) != 0) {
            textCommunicator = goalToolCallback.textCommunicator;
        }
        if ((n & 4) != 0) {
            string = goalToolCallback.name;
        }
        if ((n & 8) != 0) {
            string2 = goalToolCallback.description;
        }
        if ((n & 0x10) != 0) {
            goal = goalToolCallback.goal;
        }
        if ((n & 0x20) != 0) {
            clazz = goalToolCallback.inputType;
        }
        if ((n & 0x40) != 0) {
            list = goalToolCallback.listeners;
        }
        return goalToolCallback.copy(autonomy, textCommunicator, string, string2, goal, clazz, list);
    }

    public int hashCode() {
        int result = this.autonomy.hashCode();
        result = result * 31 + this.textCommunicator.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.description.hashCode();
        result = result * 31 + this.goal.hashCode();
        result = result * 31 + this.inputType.hashCode();
        result = result * 31 + ((Object)this.listeners).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GoalToolCallback)) {
            return false;
        }
        GoalToolCallback goalToolCallback = (GoalToolCallback)other;
        if (!Intrinsics.areEqual((Object)this.autonomy, (Object)goalToolCallback.autonomy)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textCommunicator, (Object)goalToolCallback.textCommunicator)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)goalToolCallback.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)goalToolCallback.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.goal, (Object)goalToolCallback.goal)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputType, goalToolCallback.inputType)) {
            return false;
        }
        return Intrinsics.areEqual(this.listeners, goalToolCallback.listeners);
    }
}

