/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi;

import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.FormatUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/embabel/agent/spi/InvalidLlmReturnFormatException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "Lcom/embabel/common/core/types/HasInfoString;", "llmReturn", "", "expectedType", "Ljava/lang/Class;", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Throwable;)V", "getLlmReturn", "()Ljava/lang/String;", "getExpectedType", "()Ljava/lang/Class;", "infoString", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "embabel-agent-api"})
public final class InvalidLlmReturnFormatException
extends RuntimeException
implements HasInfoString {
    @NotNull
    private final String llmReturn;
    @NotNull
    private final Class<?> expectedType;

    public InvalidLlmReturnFormatException(@NotNull String llmReturn, @NotNull Class<?> expectedType, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)llmReturn, (String)"llmReturn");
        Intrinsics.checkNotNullParameter(expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        super("Invalid LLM return when expecting " + expectedType.getName() + ": Root cause=" + cause.getMessage(), cause);
        this.llmReturn = llmReturn;
        this.expectedType = expectedType;
    }

    @NotNull
    public final String getLlmReturn() {
        return this.llmReturn;
    }

    @NotNull
    public final Class<?> getExpectedType() {
        return this.expectedType;
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        Object object;
        if (Intrinsics.areEqual((Object)verbose, (Object)true)) {
            String string = this.getClass().getSimpleName();
            String string2 = this.expectedType.getName();
            Throwable throwable = this.getCause();
            Intrinsics.checkNotNull((Object)throwable);
            object = FormatUtilsKt.indent$default((String)(string + ": Expected type: " + string2 + ", root cause: " + throwable.getMessage() + ", return\n" + this.llmReturn), (int)indent, null, (int)2, null);
        } else {
            String string = this.getClass().getSimpleName();
            String string3 = this.expectedType.getName();
            Throwable throwable = this.getCause();
            Intrinsics.checkNotNull((Object)throwable);
            object = string + ": Expected type: " + string3 + ", root cause: " + throwable.getMessage();
        }
        return object;
    }
}

