/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core.support;

import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.core.ActionInvocation;
import com.embabel.agent.core.BlackboardKt;
import com.embabel.agent.core.Condition;
import com.embabel.agent.core.ProcessContext;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.plan.common.condition.ConditionDetermination;
import com.embabel.plan.common.condition.ConditionWorldState;
import com.embabel.plan.common.condition.WorldStateDeterminer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/core/support/BlackboardWorldStateDeterminer;", "Lcom/embabel/plan/common/condition/WorldStateDeterminer;", "processContext", "Lcom/embabel/agent/core/ProcessContext;", "<init>", "(Lcom/embabel/agent/core/ProcessContext;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "knownConditions", "", "", "determineWorldState", "Lcom/embabel/plan/common/condition/ConditionWorldState;", "determineCondition", "Lcom/embabel/plan/common/condition/ConditionDetermination;", "condition", "resolveAsAgentCondition", "Lcom/embabel/agent/core/Condition;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nBlackboardWorldStateDeterminer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackboardWorldStateDeterminer.kt\ncom/embabel/agent/core/support/BlackboardWorldStateDeterminer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1863#2,2:163\n1755#2,3:165\n1755#2,3:168\n*S KotlinDebug\n*F\n+ 1 BlackboardWorldStateDeterminer.kt\ncom/embabel/agent/core/support/BlackboardWorldStateDeterminer\n*L\n42#1:163,2\n92#1:165,3\n106#1:168,3\n*E\n"})
public final class BlackboardWorldStateDeterminer
implements WorldStateDeterminer {
    @NotNull
    private final ProcessContext processContext;
    private final Logger logger;
    @NotNull
    private final Set<String> knownConditions;

    public BlackboardWorldStateDeterminer(@NotNull ProcessContext processContext) {
        Intrinsics.checkNotNullParameter((Object)processContext, (String)"processContext");
        this.processContext = processContext;
        this.logger = LoggerFactory.getLogger(BlackboardWorldStateDeterminer.class);
        this.knownConditions = this.processContext.getAgentProcess().getAgent().getPlanningSystem().knownConditions();
    }

    @Override
    @NotNull
    public ConditionWorldState determineWorldState() {
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = this.knownConditions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String condition2 = (String)element$iv;
            boolean bl = false;
            map.put(condition2, this.determineCondition(condition2));
        }
        return new ConditionWorldState(map);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConditionDetermination determineCondition(@NotNull String condition2) {
        ConditionDetermination conditionDetermination;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)condition2, (String)"condition");
        if (StringsKt.contains$default((CharSequence)condition2, (CharSequence)":", (boolean)false, (int)2, null)) {
            boolean bl;
            Object maybeMap;
            var4_2 = new String[]{":"};
            objectArray = StringsKt.split$default((CharSequence)condition2, (String[])var4_2, (boolean)false, (int)0, (int)6, null);
            String variable = (String)objectArray.get(0);
            type = (String)objectArray.get(1);
            Object found = this.processContext.getBlackboard().get(variable);
            Object object = maybeMap = found instanceof Map ? (Map)found : null;
            if (maybeMap != null) {
                return ConditionDetermination.Companion.invoke(true);
            }
            Object value = this.processContext.getValue(variable, (String)type);
            if (Intrinsics.areEqual((Object)type, (Object)"List")) {
                bl = value != null && value instanceof List;
            } else if (Intrinsics.areEqual((Object)variable, (Object)"all")) {
                bl = true;
            } else {
                boolean determination = value != null && BlackboardKt.satisfiesType(value, (String)type);
                Object[] objectArray2 = new Object[]{condition2, determination, variable, type, value};
                this.logger.debug("Determined binding condition {}={}: variable={}, type={}, value={}", objectArray2);
                bl = determination;
            }
            boolean determination = bl;
            v2 = ConditionDetermination.Companion.invoke(determination);
        } else if (StringsKt.startsWith$default((String)condition2, (String)"hasRun_", (boolean)false, (int)2, null)) {
            boolean bl;
            ConditionDetermination.Companion companion;
            block18: {
                void $this$any$iv;
                String actionName = StringsKt.substringAfter$default((String)condition2, (String)"hasRun_", null, (int)2, null);
                type = this.processContext.getAgentProcess().getHistory();
                companion = ConditionDetermination.Companion;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ActionInvocation it = (ActionInvocation)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getActionName(), (Object)actionName)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            boolean bl3 = bl;
            determination = companion.invoke(bl3);
            var5_5 = new Object[]{condition2, determination, CollectionsKt.sorted((Iterable)this.knownConditions), HasInfoString.infoString$default((HasInfoString)this.processContext.getBlackboard(), null, (int)0, (int)3, null)};
            this.logger.debug("Determined hasRun condition {}={}: known conditions={}, bindings={}", var5_5);
            v2 = determination;
        } else {
            boolean bl;
            block19: {
                Iterable $this$any$iv = this.knownConditions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String knownCondition = (String)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)knownCondition, (Object)condition2)) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
            }
            if (bl && this.resolveAsAgentCondition(condition2) != null) {
                Condition condition3 = this.resolveAsAgentCondition(condition2);
                Intrinsics.checkNotNull((Object)condition3);
                Condition condition4 = condition3;
                determination = condition4.evaluate(OperationContext.Companion.invoke(this.processContext, condition4, SetsKt.emptySet()));
                var5_5 = new Object[]{condition4, determination, HasInfoString.infoString$default((HasInfoString)this.processContext.getBlackboard(), null, (int)0, (int)3, null)};
                this.logger.debug("Determined known condition {}={}, bindings={}", var5_5);
                v2 = determination;
            } else {
                ConditionDetermination determination = ConditionDetermination.Companion.invoke(this.processContext.getBlackboard().getCondition(condition2)).asTrueOrFalse();
                var4_2 = new Object[]{condition2, determination, CollectionsKt.sorted((Iterable)this.knownConditions), HasInfoString.infoString$default((HasInfoString)this.processContext.getBlackboard(), null, (int)0, (int)3, null)};
                this.logger.debug("Looked for explicitly set condition: determined condition {}={}: known conditions={}, bindings={}", var4_2);
                v2 = conditionDetermination = objectArray;
            }
        }
        if (conditionDetermination == ConditionDetermination.UNKNOWN) {
            objectArray = new Object[]{condition2, CollectionsKt.sorted((Iterable)this.knownConditions), HasInfoString.infoString$default((HasInfoString)this.processContext.getBlackboard(), null, (int)0, (int)3, null)};
            this.logger.warn("Determined condition {} to be unknown: knownConditions={}, bindings={}", objectArray);
        }
        return conditionDetermination;
    }

    private final Condition resolveAsAgentCondition(String condition2) {
        Object v1;
        block1: {
            Iterable iterable = this.processContext.getAgentProcess().getAgent().getConditions();
            for (Object t : iterable) {
                Condition it = (Condition)t;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it.getName(), (Object)condition2) || StringsKt.endsWith$default((String)it.getName(), (String)("." + condition2), (boolean)false, (int)2, null);
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }
}

