/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.workflow.loop;

import com.embabel.agent.api.common.workflow.loop.Attempt;
import com.embabel.agent.api.common.workflow.loop.Feedback;
import com.embabel.common.core.types.Timed;
import com.embabel.common.core.types.Timestamped;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u0003*\b\b\u0002\u0010\u0004*\u00020\u00052\u00020\u00062\u00020\u0007BA\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b0\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00018\u0001\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b0\u001dJ\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u000bJ\r\u0010\u001f\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0012J\r\u0010 \u001a\u0004\u0018\u00018\u0002\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u000bJ\u0017\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\b&\u0010'J+\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b2\u0006\u0010%\u001a\u00028\u00012\u0006\u0010)\u001a\u00028\u0002H\u0000\u00a2\u0006\u0004\b*\u0010+J\u000e\u0010,\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b0\nH\u00c2\u0003J\u0010\u0010.\u001a\u0004\u0018\u00018\u0001H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010/\u001a\u00020\u000eH\u00c6\u0003J\\\u00100\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\b\u001a\u00028\u00002\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b0\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00018\u00012\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001\u00a2\u0006\u0002\u00101J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u00105\u001a\u00020\u0017H\u00d6\u0001J\t\u00106\u001a\u000207H\u00d6\u0001R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00068"}, d2={"Lcom/embabel/agent/api/common/workflow/loop/AttemptHistory;", "INPUT", "RESULT", "", "FEEDBACK", "Lcom/embabel/agent/api/common/workflow/loop/Feedback;", "Lcom/embabel/common/core/types/Timestamped;", "Lcom/embabel/common/core/types/Timed;", "input", "_attempts", "", "Lcom/embabel/agent/api/common/workflow/loop/Attempt;", "lastResult", "timestamp", "Ljava/time/Instant;", "<init>", "(Ljava/lang/Object;Ljava/util/List;Ljava/lang/Object;Ljava/time/Instant;)V", "getInput", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTimestamp", "()Ljava/time/Instant;", "attemptCount", "", "runningTime", "Ljava/time/Duration;", "getRunningTime", "()Ljava/time/Duration;", "attempts", "", "lastAttempt", "resultToEvaluate", "lastFeedback", "()Lcom/embabel/agent/api/common/workflow/loop/Feedback;", "bestSoFar", "recordResult", "", "result", "recordResult$embabel_agent_api", "(Ljava/lang/Object;)V", "recordAttempt", "feedback", "recordAttempt$embabel_agent_api", "(Ljava/lang/Object;Lcom/embabel/agent/api/common/workflow/loop/Feedback;)Lcom/embabel/agent/api/common/workflow/loop/Attempt;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;Ljava/util/List;Ljava/lang/Object;Ljava/time/Instant;)Lcom/embabel/agent/api/common/workflow/loop/AttemptHistory;", "equals", "", "other", "hashCode", "toString", "", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nRepeatUntilAcceptable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepeatUntilAcceptable.kt\ncom/embabel/agent/api/common/workflow/loop/AttemptHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,391:1\n1971#2,14:392\n*S KotlinDebug\n*F\n+ 1 RepeatUntilAcceptable.kt\ncom/embabel/agent/api/common/workflow/loop/AttemptHistory\n*L\n66#1:392,14\n*E\n"})
public final class AttemptHistory<INPUT, RESULT, FEEDBACK extends Feedback>
implements Timestamped,
Timed {
    private final INPUT input;
    @NotNull
    private final List<Attempt<RESULT, FEEDBACK>> _attempts;
    @Nullable
    private RESULT lastResult;
    @NotNull
    private final Instant timestamp;

    public AttemptHistory(INPUT input, @NotNull List<Attempt<RESULT, FEEDBACK>> _attempts, @Nullable RESULT lastResult, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter(_attempts, (String)"_attempts");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this.input = input;
        this._attempts = _attempts;
        this.lastResult = lastResult;
        this.timestamp = timestamp;
    }

    public /* synthetic */ AttemptHistory(Object object, List list, Object object2, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        if ((n & 4) != 0) {
            object2 = null;
        }
        if ((n & 8) != 0) {
            instant = Instant.now();
        }
        this(object, list, object2, instant);
    }

    public final INPUT getInput() {
        return this.input;
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public final int attemptCount() {
        return this._attempts.size();
    }

    @NotNull
    public Duration getRunningTime() {
        Duration duration = Duration.between(this.getTimestamp(), Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return duration;
    }

    @NotNull
    public final List<Attempt<RESULT, FEEDBACK>> attempts() {
        return CollectionsKt.toList((Iterable)this._attempts);
    }

    @Nullable
    public final Attempt<RESULT, FEEDBACK> lastAttempt() {
        return (Attempt)CollectionsKt.lastOrNull(this._attempts);
    }

    @Nullable
    public final RESULT resultToEvaluate() {
        return this.lastResult;
    }

    @Nullable
    public final FEEDBACK lastFeedback() {
        Attempt<RESULT, FEEDBACK> attempt = this.lastAttempt();
        return (FEEDBACK)(attempt != null ? attempt.getFeedback() : null);
    }

    @Nullable
    public final Attempt<RESULT, FEEDBACK> bestSoFar() {
        Object v0;
        Iterable $this$maxByOrNull$iv = this._attempts;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Attempt it = (Attempt)maxElem$iv;
                boolean bl = false;
                double maxValue$iv = it.getFeedback().getScore();
                do {
                    Object e$iv = iterator$iv.next();
                    Attempt it2 = (Attempt)e$iv;
                    $i$a$-maxByOrNull-AttemptHistory$bestSoFar$1 = false;
                    double v$iv = it2.getFeedback().getScore();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    public final void recordResult$embabel_agent_api(@NotNull RESULT result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        this.lastResult = result;
    }

    @NotNull
    public final Attempt<RESULT, FEEDBACK> recordAttempt$embabel_agent_api(@NotNull RESULT result, @NotNull FEEDBACK feedback) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter(feedback, (String)"feedback");
        Attempt<RESULT, FEEDBACK> attempt = new Attempt<RESULT, FEEDBACK>(result, feedback);
        this._attempts.add(attempt);
        return attempt;
    }

    public final INPUT component1() {
        return this.input;
    }

    private final List<Attempt<RESULT, FEEDBACK>> component2() {
        return this._attempts;
    }

    private final RESULT component3() {
        return this.lastResult;
    }

    @NotNull
    public final Instant component4() {
        return this.timestamp;
    }

    @NotNull
    public final AttemptHistory<INPUT, RESULT, FEEDBACK> copy(INPUT input, @NotNull List<Attempt<RESULT, FEEDBACK>> _attempts, @Nullable RESULT lastResult, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter(_attempts, (String)"_attempts");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return new AttemptHistory<INPUT, RESULT, FEEDBACK>(input, _attempts, lastResult, timestamp);
    }

    public static /* synthetic */ AttemptHistory copy$default(AttemptHistory attemptHistory, Object object, List list, Object object2, Instant instant, int n, Object object3) {
        if ((n & 1) != 0) {
            object = attemptHistory.input;
        }
        if ((n & 2) != 0) {
            list = attemptHistory._attempts;
        }
        if ((n & 4) != 0) {
            object2 = attemptHistory.lastResult;
        }
        if ((n & 8) != 0) {
            instant = attemptHistory.timestamp;
        }
        return attemptHistory.copy(object, list, object2, instant);
    }

    @NotNull
    public String toString() {
        return "AttemptHistory(input=" + this.input + ", _attempts=" + this._attempts + ", lastResult=" + this.lastResult + ", timestamp=" + this.timestamp + ")";
    }

    public int hashCode() {
        int result = this.input == null ? 0 : this.input.hashCode();
        result = result * 31 + ((Object)this._attempts).hashCode();
        result = result * 31 + (this.lastResult == null ? 0 : this.lastResult.hashCode());
        result = result * 31 + this.timestamp.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttemptHistory)) {
            return false;
        }
        AttemptHistory attemptHistory = (AttemptHistory)other;
        if (!Intrinsics.areEqual(this.input, attemptHistory.input)) {
            return false;
        }
        if (!Intrinsics.areEqual(this._attempts, attemptHistory._attempts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.lastResult, attemptHistory.lastResult)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.timestamp, (Object)attemptHistory.timestamp);
    }
}

