/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.autonomy;

import com.embabel.agent.api.common.autonomy.AgentInvocation;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.DomainType;
import com.embabel.agent.core.Goal;
import com.embabel.agent.core.ProcessOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0010\"\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J/\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0010\"\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/api/common/autonomy/DefaultAgentInvocation;", "T", "", "Lcom/embabel/agent/api/common/autonomy/AgentInvocation;", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "processOptions", "Lcom/embabel/agent/core/ProcessOptions;", "resultType", "Ljava/lang/Class;", "<init>", "(Lcom/embabel/agent/core/AgentPlatform;Lcom/embabel/agent/core/ProcessOptions;Ljava/lang/Class;)V", "invokeAsync", "Ljava/util/concurrent/CompletableFuture;", "obj", "objs", "", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;", "map", "", "", "runAsync", "Lcom/embabel/agent/core/AgentProcess;", "findAgentByResultType", "Lcom/embabel/agent/core/Agent;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAgentInvocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentInvocation.kt\ncom/embabel/agent/api/common/autonomy/DefaultAgentInvocation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1755#2,3:270\n*S KotlinDebug\n*F\n+ 1 AgentInvocation.kt\ncom/embabel/agent/api/common/autonomy/DefaultAgentInvocation\n*L\n263#1:270,3\n*E\n"})
public final class DefaultAgentInvocation<T>
implements AgentInvocation<T> {
    @NotNull
    private final AgentPlatform agentPlatform;
    @NotNull
    private final ProcessOptions processOptions;
    @NotNull
    private final Class<T> resultType;

    public DefaultAgentInvocation(@NotNull AgentPlatform agentPlatform, @NotNull ProcessOptions processOptions, @NotNull Class<T> resultType) {
        Intrinsics.checkNotNullParameter((Object)agentPlatform, (String)"agentPlatform");
        Intrinsics.checkNotNullParameter((Object)processOptions, (String)"processOptions");
        Intrinsics.checkNotNullParameter(resultType, (String)"resultType");
        this.agentPlatform = agentPlatform;
        this.processOptions = processOptions;
        this.resultType = resultType;
    }

    @Override
    @NotNull
    public CompletableFuture<T> invokeAsync(@NotNull Object obj, Object ... objs) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)objs, (String)"objs");
        CompletionStage completionStage = this.runAsync(obj, Arrays.copyOf(objs, objs.length)).thenApply(arg_0 -> DefaultAgentInvocation.invokeAsync$lambda$1(arg_0 -> DefaultAgentInvocation.invokeAsync$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<T> invokeAsync(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        CompletionStage completionStage = this.runAsync(map).thenApply(arg_0 -> DefaultAgentInvocation.invokeAsync$lambda$3(arg_0 -> DefaultAgentInvocation.invokeAsync$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<AgentProcess> runAsync(@NotNull Object obj, Object ... objs) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)objs, (String)"objs");
        Agent agent = this.findAgentByResultType();
        if (agent == null) {
            throw new IllegalStateException(("No agent with outputClass " + this.resultType + " found.").toString());
        }
        Agent agent2 = agent;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(obj);
        spreadBuilder.addSpread((Object)objs);
        Object[] args = spreadBuilder.toArray(new Object[spreadBuilder.size()]);
        AgentProcess agentProcess = this.agentPlatform.createAgentProcessFrom(agent2, this.processOptions, Arrays.copyOf(args, args.length));
        return this.agentPlatform.start(agentProcess);
    }

    @Override
    @NotNull
    public CompletableFuture<AgentProcess> runAsync(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Agent agent = this.findAgentByResultType();
        if (agent == null) {
            throw new IllegalStateException(("No agent with outputClass " + this.resultType + " found.").toString());
        }
        Agent agent2 = agent;
        AgentProcess agentProcess = this.agentPlatform.createAgentProcess(agent2, this.processOptions, map);
        return this.agentPlatform.start(agentProcess);
    }

    private final Agent findAgentByResultType() {
        Object v3;
        block5: {
            Iterable iterable = this.agentPlatform.agents();
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    Agent agent = (Agent)t;
                    boolean bl2 = false;
                    Iterable $this$any$iv = agent.getGoals();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Goal goal = (Goal)element$iv;
                            boolean bl3 = false;
                            DomainType domainType = goal.getOutputType();
                            boolean bl4 = domainType != null ? domainType.isAssignableTo(this.resultType) : false;
                            if (!bl4) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v3 = t;
                break block5;
            }
            v3 = null;
        }
        return v3;
    }

    private static final Object invokeAsync$lambda$0(DefaultAgentInvocation this$0, AgentProcess it) {
        return it.last(this$0.resultType);
    }

    private static final Object invokeAsync$lambda$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final Object invokeAsync$lambda$2(DefaultAgentInvocation this$0, AgentProcess it) {
        return it.last(this$0.resultType);
    }

    private static final Object invokeAsync$lambda$3(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }
}

