/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.autonomy;

import com.embabel.agent.api.common.autonomy.ProcessExecutionException;
import com.embabel.agent.api.common.autonomy.ProcessExecutionFailedException;
import com.embabel.agent.api.common.autonomy.ProcessExecutionStuckException;
import com.embabel.agent.api.common.autonomy.ProcessExecutionTerminatedException;
import com.embabel.agent.api.common.autonomy.ProcessWaitingException;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.AgentProcessStatusCode;
import com.embabel.agent.core.hitl.Awaitable;
import com.embabel.common.core.types.HasInfoString;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/embabel/agent/api/common/autonomy/AgentProcessExecution;", "Lcom/embabel/common/core/types/HasInfoString;", "basis", "", "output", "agentProcess", "Lcom/embabel/agent/core/AgentProcess;", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/embabel/agent/core/AgentProcess;)V", "getBasis", "()Ljava/lang/Object;", "getOutput", "getAgentProcess", "()Lcom/embabel/agent/core/AgentProcess;", "infoString", "", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "toString", "Companion", "embabel-agent-api"})
public final class AgentProcessExecution
implements HasInfoString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object basis;
    @NotNull
    private final Object output;
    @NotNull
    private final AgentProcess agentProcess;

    private AgentProcessExecution(Object basis, Object output, AgentProcess agentProcess) {
        this.basis = basis;
        this.output = output;
        this.agentProcess = agentProcess;
    }

    @NotNull
    public final Object getBasis() {
        return this.basis;
    }

    @NotNull
    public final Object getOutput() {
        return this.output;
    }

    @NotNull
    public final AgentProcess getAgentProcess() {
        return this.agentProcess;
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        return Intrinsics.areEqual((Object)verbose, (Object)true) ? this.getClass().getSimpleName() + "(basis=" + this.basis + ", output=" + this.output + ", agentProcess=" + this.agentProcess.infoString(verbose, 1) + ")" : this.getClass().getSimpleName() + "(basis=" + this.basis + ", output=" + Reflection.getOrCreateKotlinClass(this.output.getClass()).getSimpleName() + ", agentProcess=" + this.agentProcess.getId() + ")";
    }

    @NotNull
    public String toString() {
        return HasInfoString.infoString$default((HasInfoString)this, (Boolean)false, (int)0, (int)2, null);
    }

    public /* synthetic */ AgentProcessExecution(Object basis, Object output, AgentProcess agentProcess, DefaultConstructorMarker $constructor_marker) {
        this(basis, output, agentProcess);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/embabel/agent/api/common/autonomy/AgentProcessExecution$Companion;", "", "<init>", "()V", "fromProcessStatus", "Lcom/embabel/agent/api/common/autonomy/AgentProcessExecution;", "basis", "agentProcess", "Lcom/embabel/agent/core/AgentProcess;", "embabel-agent-api"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final AgentProcessExecution fromProcessStatus(@NotNull Object basis, @NotNull AgentProcess agentProcess) throws ProcessExecutionException, ProcessExecutionStuckException, ProcessExecutionFailedException, ProcessWaitingException, ProcessExecutionTerminatedException {
            Intrinsics.checkNotNullParameter((Object)basis, (String)"basis");
            Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
            switch (WhenMappings.$EnumSwitchMapping$0[((AgentProcessStatusCode)agentProcess.getStatus()).ordinal()]) {
                case 1: {
                    Object object = agentProcess.lastResult();
                    Intrinsics.checkNotNull((Object)object);
                    return new AgentProcessExecution(basis, object, agentProcess, null);
                }
                case 2: {
                    Object object = agentProcess.lastResult();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.embabel.agent.core.hitl.Awaitable<*, com.embabel.agent.core.hitl.AwaitableResponse>");
                    throw new ProcessWaitingException(agentProcess, (Awaitable)object);
                }
                case 3: {
                    throw new ProcessExecutionFailedException(agentProcess, "Process " + agentProcess.getId() + " failed: " + agentProcess.getFailureInfo());
                }
                case 4: {
                    throw new ProcessExecutionStuckException(agentProcess, "Process " + agentProcess.getId() + " stuck");
                }
                case 5: {
                    throw new ProcessExecutionTerminatedException(agentProcess, "Process " + agentProcess.getId() + " was terminated: " + agentProcess.getFailureInfo());
                }
            }
            throw new IllegalStateException(("Unexpected process status: " + agentProcess.getStatus()).toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AgentProcessStatusCode.values().length];
                try {
                    nArray[AgentProcessStatusCode.COMPLETED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AgentProcessStatusCode.WAITING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AgentProcessStatusCode.FAILED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AgentProcessStatusCode.STUCK.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AgentProcessStatusCode.TERMINATED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

