/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.plan.goap;

import com.embabel.plan.goap.ConditionDetermination;
import com.embabel.plan.goap.GoapAction;
import com.embabel.plan.goap.GoapGoal;
import com.embabel.plan.goap.GoapPlan;
import com.embabel.plan.goap.GoapWorldState;
import com.embabel.plan.goap.OptimizingGoapPlanner;
import com.embabel.plan.goap.SearchNode;
import com.embabel.plan.goap.WorldStateDeterminer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\fH\u0002J8\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u00102 \u0010\u001d\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001f0\u001e2\u0006\u0010 \u001a\u00020\tH\u0002\u00a8\u0006!"}, d2={"Lcom/embabel/plan/goap/AStarGoapPlanner;", "Lcom/embabel/plan/goap/OptimizingGoapPlanner;", "worldStateDeterminer", "Lcom/embabel/plan/goap/WorldStateDeterminer;", "<init>", "(Lcom/embabel/plan/goap/WorldStateDeterminer;)V", "planToGoalFrom", "Lcom/embabel/plan/goap/GoapPlan;", "startState", "Lcom/embabel/plan/goap/GoapWorldState;", "actions", "", "Lcom/embabel/plan/goap/GoapAction;", "goal", "Lcom/embabel/plan/goap/GoapGoal;", "backwardPlanningOptimization", "", "plan", "forwardPlanningOptimization", "simulatePlan", "isGoalReachable", "", "heuristic", "", "state", "applyAction", "currentState", "action", "reconstructPath", "cameFrom", "", "Lkotlin/Pair;", "goalState", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAStarGoapPlanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AStarGoapPlanner.kt\ncom/embabel/plan/goap/AStarGoapPlanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,384:1\n1062#2:385\n216#3,2:386\n188#3,3:388\n205#3,4:391\n216#3,2:395\n*S KotlinDebug\n*F\n+ 1 AStarGoapPlanner.kt\ncom/embabel/plan/goap/AStarGoapPlanner\n*L\n109#1:385\n192#1:386,2\n231#1:388,3\n315#1:391,4\n326#1:395,2\n*E\n"})
public final class AStarGoapPlanner
extends OptimizingGoapPlanner {
    public AStarGoapPlanner(@NotNull WorldStateDeterminer worldStateDeterminer) {
        Intrinsics.checkNotNullParameter((Object)worldStateDeterminer, (String)"worldStateDeterminer");
        super(worldStateDeterminer);
    }

    @Override
    @Nullable
    protected GoapPlan planToGoalFrom(@NotNull GoapWorldState startState, @NotNull Collection<? extends GoapAction> actions, @NotNull GoapGoal goal) {
        Intrinsics.checkNotNullParameter((Object)startState, (String)"startState");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        if (goal.isAchievable(startState)) {
            return new GoapPlan(CollectionsKt.emptyList(), goal, startState);
        }
        if (!this.isGoalReachable(startState, actions, goal)) {
            return null;
        }
        PriorityQueue<SearchNode> openList = new PriorityQueue<SearchNode>();
        Map gScores = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), AStarGoapPlanner::planToGoalFrom$lambda$0);
        Map cameFrom = new LinkedHashMap();
        Set closedSet = new LinkedHashSet();
        gScores.put(startState, 0.0);
        openList.add(new SearchNode(startState, 0.0, this.heuristic(startState, goal)));
        SearchNode bestGoalNode = null;
        double bestGoalScore = Double.MAX_VALUE;
        int iterationCount = 0;
        int maxIterations = 10000;
        while (!((Collection)openList).isEmpty() && iterationCount < maxIterations) {
            ++iterationCount;
            SearchNode current = (SearchNode)openList.poll();
            if (bestGoalNode != null && current.getGScore() >= bestGoalScore || closedSet.contains(current.getState())) continue;
            closedSet.add(current.getState());
            if (goal.isAchievable(current.getState())) {
                if (bestGoalNode != null && !(current.getGScore() < bestGoalScore)) continue;
                bestGoalNode = current;
                bestGoalScore = current.getGScore();
                continue;
            }
            Iterable $this$sortedByDescending$iv = actions;
            boolean $i$f$sortedByDescending = false;
            List sortedActions = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    GoapAction it = (GoapAction)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPreconditions().size());
                    it = (GoapAction)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPreconditions().size()));
                }
            });
            for (GoapAction action : sortedActions) {
                boolean bl;
                GoapWorldState nextState;
                if (!action.isAchievable(current.getState()) || Intrinsics.areEqual((Object)(nextState = this.applyAction(current.getState(), action)), (Object)current.getState())) continue;
                double tentativeGScore = ((Number)MapsKt.getValue((Map)gScores, (Object)current.getState())).doubleValue() + action.getCost();
                if (bestGoalNode != null && tentativeGScore >= bestGoalScore || !(tentativeGScore < ((Number)MapsKt.getValue((Map)gScores, (Object)nextState)).doubleValue())) continue;
                cameFrom.put(nextState, new Pair((Object)current.getState(), (Object)action));
                Double d = tentativeGScore;
                gScores.put(nextState, d);
                if (!closedSet.contains(nextState)) {
                    bl = openList.add(new SearchNode(nextState, tentativeGScore, this.heuristic(nextState, goal)));
                    continue;
                }
                closedSet.remove(nextState);
                bl = openList.add(new SearchNode(nextState, tentativeGScore, this.heuristic(nextState, goal)));
            }
        }
        if (bestGoalNode != null) {
            List<GoapAction> plan = this.reconstructPath(cameFrom, bestGoalNode.getState());
            List<GoapAction> optimizedPlan = this.backwardPlanningOptimization(plan, startState, goal);
            List<GoapAction> finalPlan = this.forwardPlanningOptimization(optimizedPlan, startState, goal);
            return new GoapPlan(finalPlan, goal, startState);
        }
        return null;
    }

    private final List<GoapAction> backwardPlanningOptimization(List<? extends GoapAction> plan, GoapWorldState startState, GoapGoal goal) {
        if (plan.isEmpty()) {
            return plan;
        }
        Map targetConditions = MapsKt.toMutableMap(goal.getPreconditions());
        List keptActions = new ArrayList();
        for (GoapAction action : CollectionsKt.reversed((Iterable)plan)) {
            boolean isNecessary = false;
            for (Map.Entry<String, ConditionDetermination> entry : action.getEffects().entrySet()) {
                String key = entry.getKey();
                ConditionDetermination value = entry.getValue();
                if (targetConditions.get(key) != value) continue;
                isNecessary = true;
                targetConditions.remove(key);
                Map<String, ConditionDetermination> $this$forEach$iv = action.getPreconditions();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, ConditionDetermination>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ConditionDetermination> element$iv;
                    Map.Entry<String, ConditionDetermination> entry2 = element$iv = iterator.next();
                    boolean bl = false;
                    String precKey = entry2.getKey();
                    ConditionDetermination precValue = entry2.getValue();
                    targetConditions.put(precKey, precValue);
                }
            }
            if (!isNecessary) continue;
            keptActions.add(action);
        }
        return CollectionsKt.reversed((Iterable)keptActions);
    }

    /*
     * Unable to fully structure code
     */
    private final List<GoapAction> forwardPlanningOptimization(List<? extends GoapAction> plan, GoapWorldState startState, GoapGoal goal) {
        if (plan.isEmpty()) {
            return plan;
        }
        optimizedPlan = new ArrayList<E>();
        currentState = null;
        currentState = startState;
        for (GoapAction action : plan) {
            block8: {
                if (!action.isAchievable(currentState)) continue;
                nextState = this.applyAction(currentState, action);
                if (Intrinsics.areEqual((Object)nextState, (Object)currentState)) ** GOTO lbl-1000
                $this$any$iv = action.getEffects();
                $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    v0 = false;
                } else {
                    var12_12 = $this$any$iv.entrySet().iterator();
                    while (var12_12.hasNext()) {
                        var14_14 = element$iv = var12_12.next();
                        $i$a$-any-AStarGoapPlanner$forwardPlanningOptimization$progressMade$1 = false;
                        key = var14_14.getKey();
                        value = var14_14.getValue();
                        if (!(goal.getPreconditions().containsKey(key) != false && currentState.getState().get(key) != goal.getPreconditions().get(key) && (value == goal.getPreconditions().get(key) || nextState.getState().containsKey(key) == false))) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = false;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!(progressMade = v1)) continue;
            optimizedPlan.add(action);
            currentState = nextState;
        }
        finalState = this.simulatePlan(startState, optimizedPlan);
        if (!goal.isAchievable(finalState) && ((Collection)plan).isEmpty() == false) {
            return plan;
        }
        return optimizedPlan;
    }

    private final GoapWorldState simulatePlan(GoapWorldState startState, List<? extends GoapAction> actions) {
        GoapWorldState currentState = startState;
        for (GoapAction goapAction : actions) {
            if (!goapAction.isAchievable(currentState)) continue;
            currentState = this.applyAction(currentState, goapAction);
        }
        return currentState;
    }

    private final boolean isGoalReachable(GoapWorldState startState, Collection<? extends GoapAction> actions, GoapGoal goal) {
        Set producibleEffects = new LinkedHashSet();
        for (GoapAction entry : actions) {
            for (Map.Entry<String, ConditionDetermination> entry2 : entry.getEffects().entrySet()) {
                String key = entry2.getKey();
                ConditionDetermination value = entry2.getValue();
                producibleEffects.add(TuplesKt.to((Object)key, (Object)((Object)value)));
            }
        }
        for (Map.Entry entry : goal.getPreconditions().entrySet()) {
            String key = (String)entry.getKey();
            ConditionDetermination value = (ConditionDetermination)((Object)entry.getValue());
            if (startState.getState().get(key) == value || producibleEffects.contains(TuplesKt.to((Object)key, (Object)((Object)value)))) continue;
            return false;
        }
        return true;
    }

    private final double heuristic(GoapWorldState state, GoapGoal goal) {
        int n;
        Map<String, ConditionDetermination> $this$count$iv = goal.getPreconditions();
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator<Map.Entry<String, ConditionDetermination>> iterator = $this$count$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ConditionDetermination> element$iv;
                Map.Entry<String, ConditionDetermination> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                ConditionDetermination value = entry.getValue();
                if (!(state.getState().get(key) != value)) continue;
                ++count$iv;
            }
            n = count$iv;
        }
        return n;
    }

    private final GoapWorldState applyAction(GoapWorldState currentState, GoapAction action) {
        Map newState = MapsKt.toMutableMap(currentState.getState());
        Map<String, ConditionDetermination> $this$forEach$iv = action.getEffects();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ConditionDetermination>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ConditionDetermination> element$iv;
            Map.Entry<String, ConditionDetermination> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            ConditionDetermination value = entry.getValue();
            newState.put(key, value);
        }
        Intrinsics.checkNotNull((Object)newState, (String)"null cannot be cast to non-null type java.util.HashMap<kotlin.String, com.embabel.plan.goap.ConditionDetermination>");
        return new GoapWorldState((HashMap)newState);
    }

    private final List<GoapAction> reconstructPath(Map<GoapWorldState, ? extends Pair<GoapWorldState, ? extends GoapAction>> cameFrom, GoapWorldState goalState) {
        List actions = new ArrayList();
        GoapWorldState currentState = goalState;
        while (cameFrom.containsKey(currentState)) {
            Pair<GoapWorldState, ? extends GoapAction> pair;
            Intrinsics.checkNotNull(cameFrom.get(currentState));
            GoapWorldState previousState = (GoapWorldState)pair.component1();
            GoapAction action = (GoapAction)pair.component2();
            if (action != null) {
                actions.add(action);
            }
            currentState = previousState;
        }
        return CollectionsKt.reversed((Iterable)actions);
    }

    private static final double planToGoalFrom$lambda$0(GoapWorldState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Double.MAX_VALUE;
    }
}

