/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.web.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0012J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0012R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/embabel/agent/web/rest/CustomErrorController;", "Lorg/springframework/boot/web/servlet/error/ErrorController;", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "handleError", "Lorg/springframework/http/ResponseEntity;", "", "", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "getErrorStatus", "Lorg/springframework/http/HttpStatus;", "getClientIp", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nCustomErrorController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomErrorController.kt\ncom/embabel/agent/web/rest/CustomErrorController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public class CustomErrorController
implements ErrorController {
    private final Logger logger = LoggerFactory.getLogger(CustomErrorController.class);

    @RequestMapping(value={"/error"})
    @NotNull
    public ResponseEntity<Map<String, Object>> handleError(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpStatus status = this.getErrorStatus(request);
        String path = (String)request.getAttribute("jakarta.servlet.error.request_uri");
        String method = request.getMethod();
        if (status == HttpStatus.NOT_FOUND) {
            this.logger.warn("404 Not Found - Method: " + method + ", Path: " + path + ", Client IP: " + this.getClientIp(request));
        }
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)status));
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"status", (Object)status.value());
        pairArray[1] = TuplesKt.to((Object)"error", (Object)status.getReasonPhrase());
        String string = path;
        if (string == null) {
            string = "Unknown path";
        }
        pairArray[2] = TuplesKt.to((Object)"path", (Object)string);
        ResponseEntity responseEntity = bodyBuilder.body((Object)MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    private HttpStatus getErrorStatus(HttpServletRequest request) {
        Integer n;
        block3: {
            block2: {
                Integer statusCode = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
                n = statusCode;
                if (n == null) break block2;
                int it = ((Number)n).intValue();
                boolean bl = false;
                HttpStatus httpStatus = HttpStatus.valueOf((int)it);
                n = httpStatus;
                if (httpStatus != null) break block3;
            }
            n = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return n;
    }

    private String getClientIp(HttpServletRequest request) {
        String string = request.getHeader("X-Forwarded-For");
        if (string == null && (string = request.getHeader("X-Real-IP")) == null) {
            String string2 = request.getRemoteAddr();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRemoteAddr(...)");
        }
        return string;
    }
}

