/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.agent;

import com.embabel.agent.api.common.autonomy.AgentProcessExecution;
import com.embabel.agent.api.common.autonomy.ProcessWaitingException;
import com.embabel.agent.core.hitl.Awaitable;
import com.embabel.agent.core.hitl.AwaitableResponse;
import com.embabel.agent.core.hitl.ConfirmationRequest;
import com.embabel.agent.core.hitl.FormBindingRequest;
import com.embabel.agent.domain.library.HasContent;
import com.embabel.agent.tools.agent.TextCommunicator;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.core.types.NamedAndDescribed;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/embabel/agent/tools/agent/PromptedTextCommunicator;", "Lcom/embabel/agent/tools/agent/TextCommunicator;", "<init>", "()V", "communicateResult", "", "agentProcessExecution", "Lcom/embabel/agent/api/common/autonomy/AgentProcessExecution;", "communicateAwaitable", "goal", "Lcom/embabel/common/core/types/NamedAndDescribed;", "pwe", "Lcom/embabel/agent/api/common/autonomy/ProcessWaitingException;", "embabel-agent-api"})
public final class PromptedTextCommunicator
implements TextCommunicator {
    @NotNull
    public static final PromptedTextCommunicator INSTANCE = new PromptedTextCommunicator();

    private PromptedTextCommunicator() {
    }

    @Override
    @NotNull
    public String communicateResult(@NotNull AgentProcessExecution agentProcessExecution) {
        Intrinsics.checkNotNullParameter((Object)agentProcessExecution, (String)"agentProcessExecution");
        Object output = agentProcessExecution.getOutput();
        return output instanceof String ? (String)output : (output instanceof HasInfoString ? HasInfoString.infoString$default((HasInfoString)((HasInfoString)output), (Boolean)true, (int)0, (int)2, null) : (output instanceof HasContent ? ((HasContent)output).getContent() : output.toString()));
    }

    @Override
    @NotNull
    public String communicateAwaitable(@NotNull NamedAndDescribed goal, @NotNull ProcessWaitingException pwe) {
        String string;
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter((Object)pwe, (String)"pwe");
        Awaitable<?, AwaitableResponse> awaitable = pwe.getAwaitable();
        if (awaitable instanceof FormBindingRequest) {
            string = StringsKt.trimIndent((String)("\n                You must invoke the submitFormAndResumeProcess tool to proceed with the goal \"" + goal.getName() + "\".\n                The arguments will be\n                - processId: " + pwe.getAgentProcess().getId() + ",\n                - formData: English text describing the form data to submit. See below\n\n                Before invoking this, you must obtain information from the user\n                as described in this form structure.\n                " + pwe.getAwaitable() + "\n                "));
        } else if (awaitable instanceof ConfirmationRequest) {
            string = StringsKt.trimIndent((String)("\n                Please ask the user to confirm before proceeding with the goal \"" + goal.getName() + "\".\n                The confirmation request is as follows:\n                '" + ((ConfirmationRequest)pwe.getAwaitable()).getMessage() + "'\n                Use your judgment to determine how to ask the user for confirmation\n                and what confirmation will be acceptable.\n\n                Once the user has responded, you must invoke the _confirm tool\n                with the following arguments:\n                - awaitableId: " + pwe.getAgentProcess().getId() + "\n                - confirmed: true if the user confirmed, false if they rejected the request.\n                "));
        } else {
            String string2 = "HITL error: Unsupported Awaitable type: " + HasInfoString.infoString$default((HasInfoString)pwe.getAwaitable(), (Boolean)true, (int)0, (int)2, null);
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        return string;
    }
}

