/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.support;

import com.embabel.agent.rag.Datum;
import com.embabel.agent.rag.QualityMetrics;
import com.embabel.agent.rag.RagRequest;
import com.embabel.agent.rag.RagResponse;
import com.embabel.agent.rag.RagResponseEnhancement;
import com.embabel.agent.rag.RagService;
import com.embabel.agent.rag.Retrievable;
import com.embabel.agent.rag.support.RagFacet;
import com.embabel.agent.rag.support.RagFacetProvider;
import com.embabel.common.core.types.SimilarityResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001f\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u001f\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lcom/embabel/agent/rag/support/FacetedRagService;", "Lcom/embabel/agent/rag/RagService;", "name", "", "description", "facets", "", "Lcom/embabel/agent/rag/support/RagFacet;", "Lcom/embabel/agent/rag/Retrievable;", "facetProviders", "Lcom/embabel/agent/rag/support/RagFacetProvider;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getDescription", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "ragFacets", "getRagFacets", "()Ljava/util/List;", "search", "Lcom/embabel/agent/rag/RagResponse;", "ragRequest", "Lcom/embabel/agent/rag/RagRequest;", "infoString", "verbose", "", "indent", "", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nFacetedRagService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetedRagService.kt\ncom/embabel/agent/rag/support/FacetedRagService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1368#2:65\n1454#2,5:66\n1368#2:71\n1454#2,5:72\n1663#2,8:77\n*S KotlinDebug\n*F\n+ 1 FacetedRagService.kt\ncom/embabel/agent/rag/support/FacetedRagService\n*L\n36#1:65\n36#1:66,5\n44#1:71\n44#1:72,5\n50#1:77,8\n*E\n"})
public final class FacetedRagService
implements RagService {
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    private final Logger logger;
    @NotNull
    private final List<RagFacet<? extends Retrievable>> ragFacets;

    /*
     * WARNING - void declaration
     */
    public FacetedRagService(@NotNull String name, @NotNull String description, @NotNull List<? extends RagFacet<? extends Retrievable>> facets, @NotNull List<? extends RagFacetProvider> facetProviders) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(facets, (String)"facets");
        Intrinsics.checkNotNullParameter(facetProviders, (String)"facetProviders");
        this.name = name;
        this.description = description;
        this.logger = LoggerFactory.getLogger(FacetedRagService.class);
        Iterable iterable = facetProviders;
        Collection collection = CollectionsKt.toList((Iterable)facets);
        FacetedRagService facetedRagService = this;
        boolean $i$f$flatMap = false;
        void var7_9 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RagFacetProvider it = (RagFacetProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.facets();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        facetedRagService.ragFacets = CollectionsKt.plus((Collection)collection, (Iterable)list);
        this.logger.info("Discovered {} RagFacets", (Object)this.ragFacets.size());
    }

    public /* synthetic */ FacetedRagService(String string, String string2, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        this(string, string2, list, list2);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public final List<RagFacet<? extends Retrievable>> getRagFacets() {
        return this.ragFacets;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RagResponse search(@NotNull RagRequest ragRequest) {
        void $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ragRequest, (String)"ragRequest");
        Iterable $this$flatMap$iv = this.ragFacets;
        boolean $i$f$flatMap22 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RagFacet facet = (RagFacet)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = facet.search(ragRequest).getResults();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allResults = (List)destination$iv$iv;
        Iterable $i$f$flatMap22 = allResults;
        String string = this.getName();
        RagRequest ragRequest2 = ragRequest;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            SimilarityResult it = (SimilarityResult)e$iv;
            boolean bl = false;
            String key$iv = ((Datum)it.getMatch()).getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List list = list$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Instant instant = null;
        QualityMetrics qualityMetrics = null;
        RagResponseEnhancement ragResponseEnhancement = null;
        List list2 = list;
        String string2 = string;
        RagRequest ragRequest3 = ragRequest2;
        RagResponse ragResponse = new RagResponse(ragRequest3, string2, list2, ragResponseEnhancement, qualityMetrics, instant, n, defaultConstructorMarker);
        this.logger.debug("RagResponse: {}", (Object)ragResponse);
        return ragResponse;
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        return this.ragFacets.isEmpty() ? "No RagFacets" : "Composite of " + this.getDescription();
    }
}

