/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.experimental.primitive;

import com.embabel.agent.api.common.InteractionId;
import com.embabel.agent.api.common.OperationContext;
import com.embabel.agent.core.Condition;
import com.embabel.agent.experimental.primitive.Determination;
import com.embabel.agent.spi.LlmCall;
import com.embabel.agent.spi.LlmInteraction;
import com.embabel.chat.UserMessage;
import com.embabel.plan.goap.ConditionDetermination;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B:\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\u0002\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u0006H\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J$\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\u0002\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\nH\u00c6\u0003JB\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032#\b\u0002\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\u0002\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR,\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\u0002\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0018\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/embabel/agent/experimental/primitive/PromptCondition;", "Lcom/embabel/agent/core/Condition;", "name", "", "prompt", "Lkotlin/Function1;", "Lcom/embabel/agent/api/common/OperationContext;", "Lkotlin/ParameterName;", "context", "llm", "Lcom/embabel/agent/spi/LlmCall;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lcom/embabel/agent/spi/LlmCall;)V", "getName", "()Ljava/lang/String;", "getPrompt", "()Lkotlin/jvm/functions/Function1;", "getLlm", "()Lcom/embabel/agent/spi/LlmCall;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "cost", "", "Lcom/embabel/common/core/types/ZeroToOne;", "getCost", "()D", "evaluate", "Lcom/embabel/plan/goap/ConditionDetermination;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "embabel-agent-api"})
public final class PromptCondition
implements Condition {
    @NotNull
    private final String name;
    @NotNull
    private final Function1<OperationContext, String> prompt;
    @NotNull
    private final LlmCall llm;
    private final Logger logger;
    private final double cost;

    public PromptCondition(@NotNull String name, @NotNull Function1<? super OperationContext, String> prompt, @NotNull LlmCall llm) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        this.name = name;
        this.prompt = prompt;
        this.llm = llm;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.cost = 1.0;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Function1<OperationContext, String> getPrompt() {
        return this.prompt;
    }

    @NotNull
    public final LlmCall getLlm() {
        return this.llm;
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    @NotNull
    public ConditionDetermination evaluate(@NotNull OperationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String prompt = StringsKt.trimIndent((String)("\n            Evaluate this condition: " + this.prompt.invoke((Object)context) + "\n            Return \"result\": whether you think it is true, your confidence level from 0-1,\n            and an explanation of what you base this on.\n            "));
        this.logger.info("Condition {}: making LLM call to evaluate using {}...", (Object)this.getName(), (Object)this.llm);
        LlmInteraction interaction = LlmInteraction.Companion.from-5V0vsfg(this.llm, InteractionId.constructor-impl("condition-" + this.getName()));
        Determination determination = context.getProcessContext().getPlatformServices$embabel_agent_api().getLlmOperations().createObject(CollectionsKt.listOf((Object)new UserMessage(prompt, null, null, 6, null)), interaction, Determination.class, context.getProcessContext().getAgentProcess(), null);
        Object[] objectArray = new Object[]{this.getName(), interaction.getLlm().getCriteria(), determination};
        this.logger.info("Condition {}: determination from {} was {}", objectArray);
        return ConditionDetermination.Companion.invoke(determination.getResult());
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Function1<OperationContext, String> component2() {
        return this.prompt;
    }

    @NotNull
    public final LlmCall component3() {
        return this.llm;
    }

    @NotNull
    public final PromptCondition copy(@NotNull String name, @NotNull Function1<? super OperationContext, String> prompt, @NotNull LlmCall llm) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)llm, (String)"llm");
        return new PromptCondition(name, prompt, llm);
    }

    public static /* synthetic */ PromptCondition copy$default(PromptCondition promptCondition, String string, Function1 function1, LlmCall llmCall, int n, Object object) {
        if ((n & 1) != 0) {
            string = promptCondition.name;
        }
        if ((n & 2) != 0) {
            function1 = promptCondition.prompt;
        }
        if ((n & 4) != 0) {
            llmCall = promptCondition.llm;
        }
        return promptCondition.copy(string, function1, llmCall);
    }

    @NotNull
    public String toString() {
        return "PromptCondition(name=" + this.name + ", prompt=" + this.prompt + ", llm=" + this.llm + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.prompt.hashCode();
        result = result * 31 + this.llm.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PromptCondition)) {
            return false;
        }
        PromptCondition promptCondition = (PromptCondition)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)promptCondition.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.prompt, promptCondition.prompt)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.llm, (Object)promptCondition.llm);
    }
}

