/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core.support;

import com.embabel.agent.api.common.PlatformServices;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.ActionStatus;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.AgentProcessStatusCode;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.LlmInvocation;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.agent.core.support.AbstractAgentProcess;
import com.embabel.agent.core.support.BlackboardWorldStateDeterminer;
import com.embabel.agent.event.AgentProcessPlanFormulatedEvent;
import com.embabel.agent.event.GoalAchievedEvent;
import com.embabel.agent.spi.PlannerFactory;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.FormatUtilsKt;
import com.embabel.plan.Plan;
import com.embabel.plan.Planner;
import com.embabel.plan.WorldState;
import com.embabel.plan.goap.WorldStateDeterminer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0004J\u0018\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0004J\u0018\u0010,\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0004J\u0010\u0010-\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006."}, d2={"Lcom/embabel/agent/core/support/SimpleAgentProcess;", "Lcom/embabel/agent/core/support/AbstractAgentProcess;", "id", "", "parentId", "agent", "Lcom/embabel/agent/core/Agent;", "processOptions", "Lcom/embabel/agent/core/ProcessOptions;", "blackboard", "Lcom/embabel/agent/core/Blackboard;", "platformServices", "Lcom/embabel/agent/api/common/PlatformServices;", "plannerFactory", "Lcom/embabel/agent/spi/PlannerFactory;", "timestamp", "Ljava/time/Instant;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/embabel/agent/core/Agent;Lcom/embabel/agent/core/ProcessOptions;Lcom/embabel/agent/core/Blackboard;Lcom/embabel/agent/api/common/PlatformServices;Lcom/embabel/agent/spi/PlannerFactory;Ljava/time/Instant;)V", "_llmInvocations", "", "Lcom/embabel/agent/core/LlmInvocation;", "llmInvocations", "", "getLlmInvocations", "()Ljava/util/List;", "worldStateDeterminer", "Lcom/embabel/plan/goap/WorldStateDeterminer;", "getWorldStateDeterminer", "()Lcom/embabel/plan/goap/WorldStateDeterminer;", "planner", "Lcom/embabel/plan/Planner;", "getPlanner", "()Lcom/embabel/plan/Planner;", "recordLlmInvocation", "", "llmInvocation", "handlePlanNotFound", "Lcom/embabel/agent/core/AgentProcess;", "worldState", "Lcom/embabel/plan/WorldState;", "handleProcessCompletion", "plan", "Lcom/embabel/plan/Plan;", "sendProcessRunningEvent", "formulateAndExecutePlan", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nSimpleAgentProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleAgentProcess.kt\ncom/embabel/agent/core/support/SimpleAgentProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n669#2,11:141\n1557#2:152\n1628#2,3:153\n*S KotlinDebug\n*F\n+ 1 SimpleAgentProcess.kt\ncom/embabel/agent/core/support/SimpleAgentProcess\n*L\n127#1:141,11\n129#1:152\n129#1:153,3\n*E\n"})
public class SimpleAgentProcess
extends AbstractAgentProcess {
    @NotNull
    private final List<LlmInvocation> _llmInvocations;
    @NotNull
    private final WorldStateDeterminer worldStateDeterminer;
    @NotNull
    private final Planner<?, ?, ?> planner;

    public SimpleAgentProcess(@NotNull String id, @Nullable String parentId, @NotNull Agent agent, @NotNull ProcessOptions processOptions, @NotNull Blackboard blackboard, @NotNull PlatformServices platformServices, @NotNull PlannerFactory plannerFactory, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)processOptions, (String)"processOptions");
        Intrinsics.checkNotNullParameter((Object)blackboard, (String)"blackboard");
        Intrinsics.checkNotNullParameter((Object)platformServices, (String)"platformServices");
        Intrinsics.checkNotNullParameter((Object)plannerFactory, (String)"plannerFactory");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        super(id, parentId, agent, processOptions, blackboard, platformServices, timestamp);
        this._llmInvocations = new ArrayList();
        this.worldStateDeterminer = new BlackboardWorldStateDeterminer(this.getProcessContext());
        this.planner = plannerFactory.createPlanner(processOptions, this.getWorldStateDeterminer());
    }

    public /* synthetic */ SimpleAgentProcess(String string, String string2, Agent agent, ProcessOptions processOptions, Blackboard blackboard, PlatformServices platformServices, PlannerFactory plannerFactory, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            instant = Instant.now();
        }
        this(string, string2, agent, processOptions, blackboard, platformServices, plannerFactory, instant);
    }

    @Override
    @NotNull
    public List<LlmInvocation> getLlmInvocations() {
        return CollectionsKt.toList((Iterable)this._llmInvocations);
    }

    @Override
    @NotNull
    protected WorldStateDeterminer getWorldStateDeterminer() {
        return this.worldStateDeterminer;
    }

    @Override
    @NotNull
    public Planner<?, ?, ?> getPlanner() {
        return this.planner;
    }

    @Override
    public void recordLlmInvocation(@NotNull LlmInvocation llmInvocation) {
        Intrinsics.checkNotNullParameter((Object)llmInvocation, (String)"llmInvocation");
        this._llmInvocations.add(llmInvocation);
    }

    @NotNull
    protected final AgentProcess handlePlanNotFound(@NotNull WorldState worldState) {
        Intrinsics.checkNotNullParameter((Object)worldState, (String)"worldState");
        this.getLogger().info("\u274c Process " + this.getId() + " stuck\n" + FormatUtilsKt.indentLines$default((String)StringsKt.trimMargin$default((String)("|No plan from:\n                   |" + worldState.infoString(true, 1) + "\n                   |in:\n                   |" + this.getAgent().getPlanningSystem().infoString(true, 1) + "\n                   |context:\n                   |" + this.getBlackboard().infoString(true, 1) + "\n                   |"), null, (int)1, null), (int)1, (boolean)false, (boolean)false, null, (int)14, null));
        this.setStatus(AgentProcessStatusCode.STUCK);
        return this;
    }

    protected final void handleProcessCompletion(@NotNull Plan plan, @NotNull WorldState worldState) {
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        Intrinsics.checkNotNullParameter((Object)worldState, (String)"worldState");
        Object[] objectArray = new Object[]{this.getId(), plan.getGoal().getName(), this.getRunningTime().getSeconds()};
        this.getLogger().debug("\u2705 Process {} completed, achieving goal {} in {} seconds", objectArray);
        this.getPlatformServices().getEventListener().onProcessEvent(new GoalAchievedEvent(this, worldState, plan.getGoal()));
        this.getLogger().debug("Final blackboard: {}", (Object)HasInfoString.infoString$default((HasInfoString)this.getBlackboard(), null, (int)0, (int)3, null));
        this.setStatus(AgentProcessStatusCode.COMPLETED);
    }

    protected final void sendProcessRunningEvent(@NotNull Plan plan, @NotNull WorldState worldState) {
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        Intrinsics.checkNotNullParameter((Object)worldState, (String)"worldState");
        this.getPlatformServices().getEventListener().onProcessEvent(new AgentProcessPlanFormulatedEvent(this, worldState, plan));
        Object[] objectArray = new Object[]{this.getId(), worldState, HasInfoString.infoString$default((HasInfoString)plan, null, (int)0, (int)3, null)};
        this.getLogger().debug("\u25b6\ufe0f Process {} running: {}\n\tPlan: {}", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected AgentProcess formulateAndExecutePlan(@NotNull WorldState worldState) {
        Intrinsics.checkNotNullParameter((Object)worldState, (String)"worldState");
        Object plan = this.getPlanner().bestValuePlanToAnyGoal(this.getAgent().getPlanningSystem());
        if (plan == null) {
            return this.handlePlanNotFound(worldState);
        }
        this.set_goal(((Plan)plan).getGoal());
        if (((Plan)plan).isComplete()) {
            this.handleProcessCompletion((Plan)plan, worldState);
        } else {
            Object v0;
            Object single$iv;
            Iterable $this$singleOrNull$iv;
            block7: {
                this.sendProcessRunningEvent((Plan)plan, worldState);
                $this$singleOrNull$iv = this.getAgent().getActions();
                boolean $i$f$singleOrNull = false;
                single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Action it = (Action)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)((com.embabel.plan.Action)CollectionsKt.first(((Plan)plan).getActions())).getName())) continue;
                    if (found$iv) {
                        v0 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            Action action = v0;
            if (action == null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$singleOrNull$iv = this.getAgent().getActions();
                String string = ((com.embabel.plan.Action)CollectionsKt.first(((Plan)plan).getActions())).getName();
                boolean $i$f$map = false;
                single$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Action bl = (Action)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getName());
                }
                String string2 = "No unique action found for " + string + " in " + (List)destination$iv$iv + ": Actions are\n" + CollectionsKt.joinToString$default((Iterable)this.getAgent().getActions(), (CharSequence)"\n", null, null, (int)0, null, SimpleAgentProcess::formulateAndExecutePlan$lambda$2, (int)30, null);
                throw new IllegalStateException(string2.toString());
            }
            Action agent = action;
            ActionStatus actionStatus = this.executeAction(agent);
            this.setStatus(this.actionStatusToAgentProcessStatus(actionStatus));
        }
        return this;
    }

    private static final CharSequence formulateAndExecutePlan$lambda$2(Action it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

