/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.common.autonomy;

import com.embabel.agent.api.common.autonomy.AgentProcessExecution;
import com.embabel.agent.api.common.autonomy.AutonomyProperties;
import com.embabel.agent.api.common.autonomy.GoalChoiceApprovalRequest;
import com.embabel.agent.api.common.autonomy.GoalChoiceApprovalResponse;
import com.embabel.agent.api.common.autonomy.GoalChoiceApprover;
import com.embabel.agent.api.common.autonomy.GoalChoiceNotApproved;
import com.embabel.agent.api.common.autonomy.GoalNotApproved;
import com.embabel.agent.api.common.autonomy.GoalSelectionOptions;
import com.embabel.agent.api.common.autonomy.NoAgentFound;
import com.embabel.agent.api.common.autonomy.NoGoalFound;
import com.embabel.agent.api.common.autonomy.ProcessExecutionException;
import com.embabel.agent.api.common.support.BindFieldsToBlackboardKt;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.AgentScope;
import com.embabel.agent.core.Goal;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.agent.domain.io.UserInput;
import com.embabel.agent.event.AgenticEventListener;
import com.embabel.agent.event.DynamicAgentCreationEvent;
import com.embabel.agent.event.RankingChoiceRequestEvent;
import com.embabel.agent.spi.Ranker;
import com.embabel.agent.spi.Ranking;
import com.embabel.agent.spi.Rankings;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.core.types.Named;
import com.embabel.common.util.FormatUtilsKt;
import com.embabel.plan.PlanningSystem;
import com.embabel.plan.goap.AStarGoapPlanner;
import com.embabel.plan.goap.ConditionDetermination;
import com.embabel.plan.goap.GoapAction;
import com.embabel.plan.goap.GoapPlanningSystem;
import com.embabel.plan.goap.WorldStateDeterminer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001/B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ@\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00010\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001c2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$H\u0016J(\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016JD\u0010%\u001a\u00020&2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J(\u0010)\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020(H\u0016J\u0014\u0010,\u001a\u00020$*\u00020$2\u0006\u0010-\u001a\u00020.H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/embabel/agent/api/common/autonomy/Autonomy;", "", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "ranker", "Lcom/embabel/agent/spi/Ranker;", "properties", "Lcom/embabel/agent/api/common/autonomy/AutonomyProperties;", "<init>", "(Lcom/embabel/agent/core/AgentPlatform;Lcom/embabel/agent/spi/Ranker;Lcom/embabel/agent/api/common/autonomy/AutonomyProperties;)V", "getAgentPlatform", "()Lcom/embabel/agent/core/AgentPlatform;", "getProperties", "()Lcom/embabel/agent/api/common/autonomy/AutonomyProperties;", "logger", "Lorg/slf4j/Logger;", "eventListener", "Lcom/embabel/agent/event/AgenticEventListener;", "chooseAndAccomplishGoal", "Lcom/embabel/agent/api/common/autonomy/AgentProcessExecution;", "processOptions", "Lcom/embabel/agent/core/ProcessOptions;", "goalChoiceApprover", "Lcom/embabel/agent/api/common/autonomy/GoalChoiceApprover;", "agentScope", "Lcom/embabel/agent/core/AgentScope;", "bindings", "", "", "goalSelectionOptions", "Lcom/embabel/agent/api/common/autonomy/GoalSelectionOptions;", "chooseAndRunAgent", "intent", "runAgent", "inputObject", "agent", "Lcom/embabel/agent/core/Agent;", "createGoalSeeker", "Lcom/embabel/agent/api/common/autonomy/Autonomy$GoalSeeker;", "emitEvents", "", "createGoalAgent", "goal", "Lcom/embabel/agent/core/Goal;", "prune", "userInput", "Lcom/embabel/agent/domain/io/UserInput;", "GoalSeeker", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAutonomy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Autonomy.kt\ncom/embabel/agent/api/common/autonomy/Autonomy\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,416:1\n27#2:417\n774#3:418\n865#3,2:419\n295#3,2:421\n774#3:423\n865#3,2:424\n1557#3:426\n1628#3,3:427\n1053#3:438\n1053#3:439\n37#4:430\n36#4,3:431\n126#5:434\n153#5,3:435\n*S KotlinDebug\n*F\n+ 1 Autonomy.kt\ncom/embabel/agent/api/common/autonomy/Autonomy\n*L\n78#1:417\n159#1:418\n159#1:419,2\n248#1:421,2\n266#1:423\n266#1:424,2\n274#1:426\n274#1:427,3\n395#1:438\n409#1:439\n274#1:430\n274#1:431,3\n394#1:434\n394#1:435,3\n*E\n"})
public class Autonomy {
    @NotNull
    private final AgentPlatform agentPlatform;
    @NotNull
    private final Ranker ranker;
    @NotNull
    private final AutonomyProperties properties;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AgenticEventListener eventListener;

    public Autonomy(@NotNull AgentPlatform agentPlatform, @NotNull Ranker ranker, @NotNull AutonomyProperties properties) {
        Intrinsics.checkNotNullParameter((Object)agentPlatform, (String)"agentPlatform");
        Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.agentPlatform = agentPlatform;
        this.ranker = ranker;
        this.properties = properties;
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(Autonomy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.eventListener = this.getAgentPlatform().getPlatformServices().getEventListener();
    }

    @NotNull
    public AgentPlatform getAgentPlatform() {
        return this.agentPlatform;
    }

    @NotNull
    public AutonomyProperties getProperties() {
        return this.properties;
    }

    @NotNull
    public AgentProcessExecution chooseAndAccomplishGoal(@NotNull ProcessOptions processOptions, @NotNull GoalChoiceApprover goalChoiceApprover, @NotNull AgentScope agentScope, @NotNull Map<String, ? extends Object> bindings, @NotNull GoalSelectionOptions goalSelectionOptions) throws ProcessExecutionException {
        Intrinsics.checkNotNullParameter((Object)processOptions, (String)"processOptions");
        Intrinsics.checkNotNullParameter((Object)goalChoiceApprover, (String)"goalChoiceApprover");
        Intrinsics.checkNotNullParameter((Object)agentScope, (String)"agentScope");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        Intrinsics.checkNotNullParameter((Object)goalSelectionOptions, (String)"goalSelectionOptions");
        GoalSeeker goalSeeker = this.createGoalSeeker(bindings, processOptions, goalChoiceApprover, true, agentScope, goalSelectionOptions);
        AgentPlatform agentPlatform = this.getAgentPlatform();
        Agent agent = goalSeeker.getAgent();
        AgentProcess agentProcess = agentPlatform.createAgentProcess(agent, processOptions, bindings);
        agentProcess.run();
        return AgentProcessExecution.Companion.fromProcessStatus(bindings, agentProcess);
    }

    public static /* synthetic */ AgentProcessExecution chooseAndAccomplishGoal$default(Autonomy autonomy, ProcessOptions processOptions, GoalChoiceApprover goalChoiceApprover, AgentScope agentScope, Map map, GoalSelectionOptions goalSelectionOptions, int n, Object object) throws ProcessExecutionException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: chooseAndAccomplishGoal");
        }
        if ((n & 1) != 0) {
            processOptions = new ProcessOptions(null, null, null, null, null, null, false, null, null, 511, null);
        }
        if ((n & 0x10) != 0) {
            goalSelectionOptions = new GoalSelectionOptions(null, null, false, 7, null);
        }
        return autonomy.chooseAndAccomplishGoal(processOptions, goalChoiceApprover, agentScope, map, goalSelectionOptions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AgentProcessExecution chooseAndRunAgent(@NotNull String intent, @NotNull ProcessOptions processOptions) throws ProcessExecutionException {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)processOptions, (String)"processOptions");
        UserInput userInput = new UserInput(intent);
        RankingChoiceRequestEvent<Agent> agentChoiceEvent = new RankingChoiceRequestEvent<Agent>(this.getAgentPlatform(), Agent.class, userInput, (Collection)this.getAgentPlatform().agents());
        this.eventListener.onPlatformEvent(agentChoiceEvent);
        Rankings<Agent> agentRankings = this.ranker.rank("agent", userInput.getContent(), (Collection)this.getAgentPlatform().agents());
        Iterable iterable = agentRankings.rankings();
        boolean $i$f$filter22 = false;
        Agent agent = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ranking it = (Ranking)element$iv$iv;
            boolean bl = false;
            if (!(it.getScore() > this.getProperties().getAgentConfidenceCutOff())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List credibleAgents = (List)destination$iv$iv;
        Ranking agentChoice = (Ranking)CollectionsKt.firstOrNull((List)credibleAgents);
        if (agentChoice == null) {
            this.eventListener.onPlatformEvent(agentChoiceEvent.noDeterminationEvent(agentRankings, this.getProperties().getAgentConfidenceCutOff()));
            throw new NoAgentFound(userInput, agentRankings);
        }
        Object[] $i$f$filter22 = new Object[]{((Agent)agentChoice.getMatch()).getName(), agentChoice.getScore(), intent, CollectionsKt.joinToString$default((Iterable)this.getAgentPlatform().agents(), (CharSequence)"\n", null, null, (int)0, null, Autonomy::chooseAndRunAgent$lambda$1, (int)30, null)};
        this.logger.debug("Agent choice {} with confidence {} for user intent {}: Choices were {}", $i$f$filter22);
        this.eventListener.onPlatformEvent(agentChoiceEvent.determinationEvent(agentChoice, agentRankings));
        Agent agent2 = (Agent)agentChoice.getMatch();
        agent = (Agent)agentChoice.getMatch();
        AgentPlatform agentPlatform = this.getAgentPlatform();
        this.eventListener.onPlatformEvent(new DynamicAgentCreationEvent(agentPlatform, agent, userInput, null, 8, null));
        return this.runAgent(userInput, processOptions, agent2);
    }

    public static /* synthetic */ AgentProcessExecution chooseAndRunAgent$default(Autonomy autonomy, String string, ProcessOptions processOptions, int n, Object object) throws ProcessExecutionException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: chooseAndRunAgent");
        }
        if ((n & 2) != 0) {
            processOptions = new ProcessOptions(null, null, null, null, null, null, false, null, null, 511, null);
        }
        return autonomy.chooseAndRunAgent(string, processOptions);
    }

    @NotNull
    public AgentProcessExecution runAgent(@NotNull Object inputObject, @NotNull ProcessOptions processOptions, @NotNull Agent agent) {
        Intrinsics.checkNotNullParameter((Object)inputObject, (String)"inputObject");
        Intrinsics.checkNotNullParameter((Object)processOptions, (String)"processOptions");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        AgentPlatform agentPlatform = this.getAgentPlatform();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"it", (Object)inputObject));
        AgentProcess agentProcess = agentPlatform.createAgentProcess(agent, processOptions, map);
        BindFieldsToBlackboardKt.destructureAndBindIfNecessary(inputObject, "input", agentProcess, this.logger);
        agentProcess.run();
        return AgentProcessExecution.Companion.fromProcessStatus(inputObject, agentProcess);
    }

    @NotNull
    public GoalSeeker createGoalSeeker(@NotNull String intent, @NotNull GoalChoiceApprover goalChoiceApprover, @NotNull AgentScope agentScope, @NotNull GoalSelectionOptions goalSelectionOptions) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)goalChoiceApprover, (String)"goalChoiceApprover");
        Intrinsics.checkNotNullParameter((Object)agentScope, (String)"agentScope");
        Intrinsics.checkNotNullParameter((Object)goalSelectionOptions, (String)"goalSelectionOptions");
        return this.createGoalSeeker(MapsKt.mapOf((Pair)TuplesKt.to((Object)"it", (Object)new UserInput(intent))), new ProcessOptions(null, null, null, null, null, null, false, null, null, 511, null), goalChoiceApprover, false, agentScope, goalSelectionOptions);
    }

    /*
     * WARNING - void declaration
     */
    private GoalSeeker createGoalSeeker(Map<String, ? extends Object> bindings, ProcessOptions processOptions, GoalChoiceApprover goalChoiceApprover, boolean emitEvents, AgentScope agentScope, GoalSelectionOptions goalSelectionOptions) {
        GoalChoiceApprovalResponse approval;
        Ranking goalChoice;
        Object object;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object v0;
        Object element$iv;
        block14: {
            Iterable $this$firstOrNull$iv = bindings.values();
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (!(it instanceof UserInput)) continue;
                v0 = element$iv;
                break block14;
            }
            v0 = null;
        }
        Object var9_18 = v0;
        UserInput userInput = var9_18 instanceof UserInput ? (UserInput)var9_18 : null;
        if (userInput == null) {
            throw new IllegalArgumentException("No UserInput found in bindings: " + bindings);
        }
        UserInput userInput2 = userInput;
        RankingChoiceRequestEvent<Goal> goalChoiceEvent = new RankingChoiceRequestEvent<Goal>(this.getAgentPlatform(), Goal.class, userInput2, agentScope.getGoals());
        if (emitEvents) {
            this.eventListener.onPlatformEvent(goalChoiceEvent);
        }
        Rankings<Goal> goalRankings = this.ranker.rank("goal", userInput2.getContent(), agentScope.getGoals());
        Iterable $i$f$firstOrNull = goalRankings.rankings();
        boolean $i$f$filter = false;
        element$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ranking it = (Ranking)element$iv$iv;
            boolean bl = false;
            Double d = goalSelectionOptions.getGoalConfidenceCutOff();
            if (!(it.getScore() > (d != null ? d.doubleValue() : this.getProperties().getGoalConfidenceCutOff()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List credibleGoals = (List)destination$iv$iv;
        if (goalSelectionOptions.getMultiGoal()) {
            Ranking ultimate = (Ranking)CollectionsKt.firstOrNull((List)credibleGoals);
            if (ultimate == null) {
                v3 = null;
            } else {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                Object element$iv$iv;
                Iterable $i$f$filterTo2 = CollectionsKt.drop((Iterable)credibleGoals, (int)1);
                Goal goal = (Goal)ultimate.getMatch();
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Ranking ranking = (Ranking)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add((Goal)it.getMatch());
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                object = thisCollection$iv.toArray(new Goal[0]);
                Goal multigoal = goal.withGoalPreconditions(Arrays.copyOf(object, ((Goal[])object).length));
                object = new Object[]{credibleGoals.size(), multigoal, credibleGoals};
                this.logger.info("Creating composite of {} goals: {} from credible goals: {}", object);
                v3 = new Ranking<Named>(multigoal, ultimate.getScore());
            }
        } else {
            v3 = goalChoice = (Ranking)CollectionsKt.firstOrNull((List)credibleGoals);
        }
        if (goalChoice == null) {
            this.eventListener.onPlatformEvent(goalChoiceEvent.noDeterminationEvent(goalRankings, this.getProperties().getGoalConfidenceCutOff()));
            throw new NoGoalFound(userInput2, goalRankings);
        }
        Object[] ultimate = new Object[]{((Goal)goalChoice.getMatch()).getName(), goalChoice.getScore(), userInput2.getContent(), CollectionsKt.joinToString$default((Iterable)agentScope.getGoals(), (CharSequence)"\n", null, null, (int)0, null, Autonomy::createGoalSeeker$lambda$5, (int)30, null)};
        this.logger.debug("Goal choice {} with confidence {} for user intent {}: Choices were {}", ultimate);
        if (emitEvents) {
            this.eventListener.onPlatformEvent(goalChoiceEvent.determinationEvent(goalChoice, goalRankings));
        }
        if ((approval = goalChoiceApprover.approve(new GoalChoiceApprovalRequest((Goal)goalChoice.getMatch(), userInput2.getContent(), goalRankings))) instanceof GoalChoiceNotApproved) {
            GoalNotApproved goalNotApproved = new GoalNotApproved(userInput2, goalRankings, ((GoalChoiceNotApproved)approval).getReason(), this.getAgentPlatform());
            if (emitEvents) {
                this.eventListener.onPlatformEvent(goalNotApproved);
            }
            throw goalNotApproved;
        }
        Agent goalAgent = this.createGoalAgent(userInput2, agentScope, (Goal)goalChoice.getMatch(), processOptions.getPrune());
        if (emitEvents) {
            object = this.getAgentPlatform();
            this.eventListener.onPlatformEvent(new DynamicAgentCreationEvent((AgentPlatform)object, goalAgent, userInput2, null, 8, null));
        }
        return new GoalSeeker(goalAgent, goalRankings);
    }

    @NotNull
    public Agent createGoalAgent(@NotNull Object inputObject, @NotNull AgentScope agentScope, @NotNull Goal goal, boolean prune) {
        Intrinsics.checkNotNullParameter((Object)inputObject, (String)"inputObject");
        Intrinsics.checkNotNullParameter((Object)agentScope, (String)"agentScope");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Agent agent = agentScope.createAgent("goal-" + goal.getName(), "embabel", goal.getDescription()).withSingleGoal(goal);
        return prune && inputObject instanceof UserInput ? this.prune(agent, (UserInput)inputObject) : agent;
    }

    /*
     * WARNING - void declaration
     */
    private Agent prune(Agent $this$prune, UserInput userInput) {
        Map $this$sortedBy$iv;
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        PlanningSystem planningSystem = $this$prune.getPlanningSystem();
        if (!(planningSystem instanceof GoapPlanningSystem)) {
            this.logger.warn("Pruning is only supported for GoapPlanningSystem. Skipping pruning.");
            return $this$prune;
        }
        this.logger.debug("Raw agent: {}", (Object)HasInfoString.infoString$default((HasInfoString)$this$prune, null, (int)0, (int)3, null));
        Map map = new LinkedHashMap();
        for (String condition2 : $this$prune.getPlanningSystem().knownConditions()) {
            map.put(condition2, ConditionDetermination.FALSE);
        }
        Map map2 = map;
        String string = "Pruning agent instance from:\n{}";
        Logger logger = this.logger;
        boolean $i$f$map = false;
        void var7_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)FormatUtilsKt.indent$default((String)(it.getKey() + ": " + it.getValue()), (int)1, null, (int)2, null)));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$sortedBy22 = false;
        logger.info(string, (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)((Object)$this$sortedBy$iv), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, Autonomy::prune$lambda$8, (int)30, null));
        $this$sortedBy$iv = map;
        Pair $i$f$sortedBy22 = TuplesKt.to((Object)("it:" + Reflection.getOrCreateKotlinClass(userInput.getClass()).getQualifiedName()), (Object)((Object)ConditionDetermination.TRUE));
        $this$sortedBy$iv.put($i$f$sortedBy22.getFirst(), $i$f$sortedBy22.getSecond());
        AStarGoapPlanner planner = new AStarGoapPlanner(WorldStateDeterminer.Companion.fromMap(map));
        GoapPlanningSystem pruned = planner.prune((GoapPlanningSystem)planningSystem);
        Set prunedActions = CollectionsKt.subtract((Iterable)((GoapPlanningSystem)planningSystem).getActions(), (Iterable)pruned.getActions());
        Object[] objectArray = new Object[3];
        objectArray[0] = prunedActions.size();
        Iterable $this$sortedBy$iv2 = CollectionsKt.toList((Iterable)prunedActions);
        boolean $i$f$sortedBy = false;
        objectArray[1] = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GoapAction it = (GoapAction)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (GoapAction)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, Autonomy::prune$lambda$10, (int)30, null);
        objectArray[2] = pruned.infoString(true, 1);
        this.logger.info("Pruned planning system removed {} actions:\n{} \nPruned:\n{}", objectArray);
        return $this$prune.pruneTo(pruned);
    }

    private static final CharSequence chooseAndRunAgent$lambda$1(Agent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence createGoalSeeker$lambda$5(Goal it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence prune$lambda$8(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)it.getSecond();
    }

    private static final CharSequence prune$lambda$10(GoapAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FormatUtilsKt.indent$default((String)it.getName(), (int)1, null, (int)2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/embabel/agent/api/common/autonomy/Autonomy$GoalSeeker;", "", "agent", "Lcom/embabel/agent/core/Agent;", "rankings", "Lcom/embabel/agent/spi/Rankings;", "Lcom/embabel/agent/core/Goal;", "<init>", "(Lcom/embabel/agent/core/Agent;Lcom/embabel/agent/spi/Rankings;)V", "getAgent", "()Lcom/embabel/agent/core/Agent;", "getRankings", "()Lcom/embabel/agent/spi/Rankings;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "embabel-agent-api"})
    public static final class GoalSeeker {
        @NotNull
        private final Agent agent;
        @NotNull
        private final Rankings<Goal> rankings;

        public GoalSeeker(@NotNull Agent agent, @NotNull Rankings<Goal> rankings) {
            Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
            Intrinsics.checkNotNullParameter(rankings, (String)"rankings");
            this.agent = agent;
            this.rankings = rankings;
        }

        @NotNull
        public final Agent getAgent() {
            return this.agent;
        }

        @NotNull
        public final Rankings<Goal> getRankings() {
            return this.rankings;
        }

        @NotNull
        public final Agent component1() {
            return this.agent;
        }

        @NotNull
        public final Rankings<Goal> component2() {
            return this.rankings;
        }

        @NotNull
        public final GoalSeeker copy(@NotNull Agent agent, @NotNull Rankings<Goal> rankings) {
            Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
            Intrinsics.checkNotNullParameter(rankings, (String)"rankings");
            return new GoalSeeker(agent, rankings);
        }

        public static /* synthetic */ GoalSeeker copy$default(GoalSeeker goalSeeker, Agent agent, Rankings rankings, int n, Object object) {
            if ((n & 1) != 0) {
                agent = goalSeeker.agent;
            }
            if ((n & 2) != 0) {
                rankings = goalSeeker.rankings;
            }
            return goalSeeker.copy(agent, rankings);
        }

        @NotNull
        public String toString() {
            return "GoalSeeker(agent=" + this.agent + ", rankings=" + this.rankings + ")";
        }

        public int hashCode() {
            int result = this.agent.hashCode();
            result = result * 31 + this.rankings.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GoalSeeker)) {
                return false;
            }
            GoalSeeker goalSeeker = (GoalSeeker)other;
            if (!Intrinsics.areEqual((Object)this.agent, (Object)goalSeeker.agent)) {
                return false;
            }
            return Intrinsics.areEqual(this.rankings, goalSeeker.rankings);
        }
    }
}

