/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.a2a.server.support;

import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatusUpdateEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0012R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/embabel/agent/a2a/server/support/TaskStateManager;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "activeTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/embabel/agent/a2a/server/support/TaskStateManager$TaskInfo;", "completedTasks", "registerTask", "", "taskId", "contextId", "streamId", "recordEvent", "event", "Lio/a2a/spec/StreamingEventKind;", "getTaskInfo", "getStreamId", "getTaskEvents", "", "isTaskActive", "", "taskExists", "updateStreamId", "newStreamId", "cleanupOldTasks", "olderThan", "Ljava/time/Instant;", "isTerminalState", "state", "Lio/a2a/spec/TaskState;", "TaskInfo", "embabel-agent-a2a"})
public class TaskStateManager {
    private final Logger logger = LoggerFactory.getLogger(TaskStateManager.class);
    @NotNull
    private final ConcurrentHashMap<String, TaskInfo> activeTasks = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, TaskInfo> completedTasks = new ConcurrentHashMap();

    public void registerTask(@NotNull String taskId, @NotNull String contextId, @NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)contextId, (String)"contextId");
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Object[] objectArray = new Object[]{taskId, contextId, streamId};
        this.logger.info("Registering task: taskId={}, contextId={}, streamId={}", objectArray);
        ((Map)this.activeTasks).put(taskId, new TaskInfo(taskId, contextId, streamId, null, null, null, null, 120, null));
    }

    public void recordEvent(@NotNull String taskId, @NotNull StreamingEventKind event) {
        TaskInfo taskInfo;
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TaskInfo taskInfo2 = this.activeTasks.get(taskId);
        if (taskInfo2 == null) {
            taskInfo2 = this.completedTasks.get(taskId);
        }
        if ((taskInfo = taskInfo2) != null) {
            TaskState taskState;
            taskInfo.getEvents().add(event);
            StreamingEventKind streamingEventKind = event;
            Object object = streamingEventKind instanceof Task ? ((Task)event).getStatus().state() : (taskState = streamingEventKind instanceof TaskStatusUpdateEvent ? ((TaskStatusUpdateEvent)event).getStatus().state() : null);
            if (taskState != null) {
                taskInfo.setCurrentState(taskState);
                if (this.isTerminalState(taskState)) {
                    taskInfo.setCompletedAt(Instant.now());
                    this.activeTasks.remove(taskId);
                    ((Map)this.completedTasks).put(taskId, taskInfo);
                    this.logger.info("Task {} completed with state {}", (Object)taskId, (Object)taskState);
                }
            }
        } else {
            this.logger.warn("Attempted to record event for unknown task: {}", (Object)taskId);
        }
    }

    @Nullable
    public TaskInfo getTaskInfo(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        TaskInfo taskInfo = this.activeTasks.get(taskId);
        if (taskInfo == null) {
            taskInfo = this.completedTasks.get(taskId);
        }
        return taskInfo;
    }

    @Nullable
    public String getStreamId(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        TaskInfo taskInfo = this.getTaskInfo(taskId);
        return taskInfo != null ? taskInfo.getStreamId() : null;
    }

    @NotNull
    public List<StreamingEventKind> getTaskEvents(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Object object = this.getTaskInfo(taskId);
        if (object == null || (object = ((TaskInfo)object).getEvents()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public boolean isTaskActive(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        return this.activeTasks.containsKey(taskId);
    }

    public boolean taskExists(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        return this.activeTasks.containsKey(taskId) || this.completedTasks.containsKey(taskId);
    }

    public void updateStreamId(@NotNull String taskId, @NotNull String newStreamId) {
        TaskInfo taskInfo;
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)newStreamId, (String)"newStreamId");
        TaskInfo taskInfo2 = this.activeTasks.get(taskId);
        if (taskInfo2 == null) {
            taskInfo2 = this.completedTasks.get(taskId);
        }
        if ((taskInfo = taskInfo2) != null) {
            Object[] objectArray = new Object[]{taskId, taskInfo.getStreamId(), newStreamId};
            this.logger.info("Updating stream ID for task {} from {} to {}", objectArray);
            TaskInfo updatedInfo = TaskInfo.copy$default(taskInfo, null, null, newStreamId, null, null, null, null, 123, null);
            if (this.activeTasks.containsKey(taskId)) {
                ((Map)this.activeTasks).put(taskId, updatedInfo);
            } else {
                ((Map)this.completedTasks).put(taskId, updatedInfo);
            }
        }
    }

    public void cleanupOldTasks(@NotNull Instant olderThan) {
        Intrinsics.checkNotNullParameter((Object)olderThan, (String)"olderThan");
        boolean removed = this.completedTasks.entrySet().removeIf(arg_0 -> TaskStateManager.cleanupOldTasks$lambda$1(arg_0 -> TaskStateManager.cleanupOldTasks$lambda$0(olderThan, arg_0), arg_0));
        if (removed) {
            this.logger.info("Cleaned up old completed tasks");
        }
    }

    private boolean isTerminalState(TaskState state) {
        Object[] objectArray = new TaskState[]{TaskState.COMPLETED, TaskState.FAILED, TaskState.CANCELED};
        return SetsKt.setOf((Object[])objectArray).contains(state);
    }

    private static final boolean cleanupOldTasks$lambda$0(Instant $olderThan, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Instant instant = ((TaskInfo)entry.getValue()).getCompletedAt();
        return instant != null ? instant.isBefore($olderThan) : false;
    }

    private static final boolean cleanupOldTasks$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010%\u001a\u00020\rH\u00c6\u0003JW\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0017\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lcom/embabel/agent/a2a/server/support/TaskStateManager$TaskInfo;", "", "taskId", "", "contextId", "streamId", "events", "", "Lio/a2a/spec/StreamingEventKind;", "createdAt", "Ljava/time/Instant;", "completedAt", "currentState", "Lio/a2a/spec/TaskState;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/time/Instant;Ljava/time/Instant;Lio/a2a/spec/TaskState;)V", "getTaskId", "()Ljava/lang/String;", "getContextId", "getStreamId", "getEvents", "()Ljava/util/List;", "getCreatedAt", "()Ljava/time/Instant;", "getCompletedAt", "setCompletedAt", "(Ljava/time/Instant;)V", "getCurrentState", "()Lio/a2a/spec/TaskState;", "setCurrentState", "(Lio/a2a/spec/TaskState;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-a2a"})
    public static final class TaskInfo {
        @NotNull
        private final String taskId;
        @NotNull
        private final String contextId;
        @NotNull
        private final String streamId;
        @NotNull
        private final List<StreamingEventKind> events;
        @NotNull
        private final Instant createdAt;
        @Nullable
        private Instant completedAt;
        @NotNull
        private TaskState currentState;

        public TaskInfo(@NotNull String taskId, @NotNull String contextId, @NotNull String streamId, @NotNull List<StreamingEventKind> events, @NotNull Instant createdAt, @Nullable Instant completedAt, @NotNull TaskState currentState) {
            Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
            Intrinsics.checkNotNullParameter((Object)contextId, (String)"contextId");
            Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            Intrinsics.checkNotNullParameter((Object)currentState, (String)"currentState");
            this.taskId = taskId;
            this.contextId = contextId;
            this.streamId = streamId;
            this.events = events;
            this.createdAt = createdAt;
            this.completedAt = completedAt;
            this.currentState = currentState;
        }

        public /* synthetic */ TaskInfo(String string, String string2, String string3, List list, Instant instant, Instant instant2, TaskState taskState, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list = new ArrayList();
            }
            if ((n & 0x10) != 0) {
                instant = Instant.now();
            }
            if ((n & 0x20) != 0) {
                instant2 = null;
            }
            if ((n & 0x40) != 0) {
                taskState = TaskState.WORKING;
            }
            this(string, string2, string3, list, instant, instant2, taskState);
        }

        @NotNull
        public final String getTaskId() {
            return this.taskId;
        }

        @NotNull
        public final String getContextId() {
            return this.contextId;
        }

        @NotNull
        public final String getStreamId() {
            return this.streamId;
        }

        @NotNull
        public final List<StreamingEventKind> getEvents() {
            return this.events;
        }

        @NotNull
        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(@Nullable Instant instant) {
            this.completedAt = instant;
        }

        @NotNull
        public final TaskState getCurrentState() {
            return this.currentState;
        }

        public final void setCurrentState(@NotNull TaskState taskState) {
            Intrinsics.checkNotNullParameter((Object)taskState, (String)"<set-?>");
            this.currentState = taskState;
        }

        @NotNull
        public final String component1() {
            return this.taskId;
        }

        @NotNull
        public final String component2() {
            return this.contextId;
        }

        @NotNull
        public final String component3() {
            return this.streamId;
        }

        @NotNull
        public final List<StreamingEventKind> component4() {
            return this.events;
        }

        @NotNull
        public final Instant component5() {
            return this.createdAt;
        }

        @Nullable
        public final Instant component6() {
            return this.completedAt;
        }

        @NotNull
        public final TaskState component7() {
            return this.currentState;
        }

        @NotNull
        public final TaskInfo copy(@NotNull String taskId, @NotNull String contextId, @NotNull String streamId, @NotNull List<StreamingEventKind> events, @NotNull Instant createdAt, @Nullable Instant completedAt, @NotNull TaskState currentState) {
            Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
            Intrinsics.checkNotNullParameter((Object)contextId, (String)"contextId");
            Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            Intrinsics.checkNotNullParameter((Object)currentState, (String)"currentState");
            return new TaskInfo(taskId, contextId, streamId, events, createdAt, completedAt, currentState);
        }

        public static /* synthetic */ TaskInfo copy$default(TaskInfo taskInfo, String string, String string2, String string3, List list, Instant instant, Instant instant2, TaskState taskState, int n, Object object) {
            if ((n & 1) != 0) {
                string = taskInfo.taskId;
            }
            if ((n & 2) != 0) {
                string2 = taskInfo.contextId;
            }
            if ((n & 4) != 0) {
                string3 = taskInfo.streamId;
            }
            if ((n & 8) != 0) {
                list = taskInfo.events;
            }
            if ((n & 0x10) != 0) {
                instant = taskInfo.createdAt;
            }
            if ((n & 0x20) != 0) {
                instant2 = taskInfo.completedAt;
            }
            if ((n & 0x40) != 0) {
                taskState = taskInfo.currentState;
            }
            return taskInfo.copy(string, string2, string3, list, instant, instant2, taskState);
        }

        @NotNull
        public String toString() {
            return "TaskInfo(taskId=" + this.taskId + ", contextId=" + this.contextId + ", streamId=" + this.streamId + ", events=" + this.events + ", createdAt=" + this.createdAt + ", completedAt=" + this.completedAt + ", currentState=" + this.currentState + ")";
        }

        public int hashCode() {
            int result = this.taskId.hashCode();
            result = result * 31 + this.contextId.hashCode();
            result = result * 31 + this.streamId.hashCode();
            result = result * 31 + ((Object)this.events).hashCode();
            result = result * 31 + this.createdAt.hashCode();
            result = result * 31 + (this.completedAt == null ? 0 : this.completedAt.hashCode());
            result = result * 31 + this.currentState.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TaskInfo)) {
                return false;
            }
            TaskInfo taskInfo = (TaskInfo)other;
            if (!Intrinsics.areEqual((Object)this.taskId, (Object)taskInfo.taskId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contextId, (Object)taskInfo.contextId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.streamId, (Object)taskInfo.streamId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.events, taskInfo.events)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.createdAt, (Object)taskInfo.createdAt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.completedAt, (Object)taskInfo.completedAt)) {
                return false;
            }
            return this.currentState == taskInfo.currentState;
        }
    }
}

