/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.a2a.server.support;

import com.embabel.agent.a2a.server.AgentCardHandler;
import com.embabel.agent.a2a.server.support.AgentCardHandlerWebFacade;
import com.embabel.common.core.types.HasInfoString;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletRequest;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
@Profile(value={"a2a"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0004H\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/a2a/server/support/A2AEndpointRegistrar;", "", "agentCardHandlers", "", "Lcom/embabel/agent/a2a/server/AgentCardHandler;", "requestMappingHandlerMapping", "Lorg/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerMapping;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/util/List;Lorg/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerMapping;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "onApplicationReady", "", "event", "Lorg/springframework/boot/context/event/ApplicationReadyEvent;", "registerWebEndpoints", "agentCardHandler", "embabel-agent-a2a"})
@SourceDebugExtension(value={"SMAP\nA2AEndpointRegistrar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 A2AEndpointRegistrar.kt\ncom/embabel/agent/a2a/server/support/A2AEndpointRegistrar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1863#2,2:165\n*S KotlinDebug\n*F\n+ 1 A2AEndpointRegistrar.kt\ncom/embabel/agent/a2a/server/support/A2AEndpointRegistrar\n*L\n59#1:165,2\n*E\n"})
public class A2AEndpointRegistrar {
    @NotNull
    private final List<AgentCardHandler> agentCardHandlers;
    @NotNull
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;
    @NotNull
    private final ObjectMapper objectMapper;
    private final Logger logger;

    public A2AEndpointRegistrar(@NotNull List<? extends AgentCardHandler> agentCardHandlers, @NotNull RequestMappingHandlerMapping requestMappingHandlerMapping, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter(agentCardHandlers, (String)"agentCardHandlers");
        Intrinsics.checkNotNullParameter((Object)requestMappingHandlerMapping, (String)"requestMappingHandlerMapping");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.agentCardHandlers = agentCardHandlers;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.objectMapper = objectMapper;
        this.logger = LoggerFactory.getLogger(A2AEndpointRegistrar.class);
    }

    @EventListener
    public void onApplicationReady(@NotNull ApplicationReadyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.logger.info("Registering " + this.agentCardHandlers.size() + " A2A endpoints");
        Iterable $this$forEach$iv = this.agentCardHandlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AgentCardHandler endpoint = (AgentCardHandler)element$iv;
            boolean bl = false;
            this.registerWebEndpoints(endpoint);
        }
    }

    private void registerWebEndpoints(AgentCardHandler agentCardHandler) {
        String endpointPath = "/" + agentCardHandler.getPath() + "/.well-known/agent.json";
        this.logger.info("Registering web endpoint under {} for {}", (Object)endpointPath, (Object)HasInfoString.infoString$default((HasInfoString)agentCardHandler, (Boolean)true, (int)0, (int)2, null));
        Object[] objectArray = new String[]{endpointPath};
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths((String[])objectArray);
        objectArray = new RequestMethod[]{RequestMethod.GET};
        RequestMappingInfo.Builder builder2 = builder.methods((RequestMethod[])objectArray);
        objectArray = new String[]{"application/json"};
        RequestMappingInfo requestMappingInfo = builder2.produces((String[])objectArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)requestMappingInfo, (String)"build(...)");
        RequestMappingInfo agentCardGetMapping = requestMappingInfo;
        AgentCardHandlerWebFacade achwf = new AgentCardHandlerWebFacade(agentCardHandler, this.objectMapper);
        objectArray = new Class[]{ServletRequest.class};
        this.requestMappingHandlerMapping.registerMapping(agentCardGetMapping, (Object)achwf, achwf.getClass().getMethod("agentCard", (Class<?>[])objectArray));
        Class[] classArray = new Class[]{Map.class};
        Method jsonRpcPostMethod = achwf.getClass().getMethod("handleJsonRpc", classArray);
        String[] stringArray = new String[]{agentCardHandler.getPath()};
        RequestMappingInfo.Builder builder3 = RequestMappingInfo.paths((String[])stringArray);
        stringArray = new RequestMethod[]{RequestMethod.POST};
        RequestMappingInfo.Builder builder4 = builder3.methods((RequestMethod[])stringArray);
        stringArray = new String[]{"application/json"};
        RequestMappingInfo.Builder builder5 = builder4.consumes(stringArray);
        stringArray = new String[]{"application/json", "text/event-stream"};
        RequestMappingInfo requestMappingInfo2 = builder5.produces(stringArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)requestMappingInfo2, (String)"build(...)");
        RequestMappingInfo jsonRpcPostMapping = requestMappingInfo2;
        this.requestMappingHandlerMapping.registerMapping(jsonRpcPostMapping, (Object)achwf, jsonRpcPostMethod);
    }
}

