/*
 * Decompiled with CFR 0.152.
 */
package com.emailage.javawrapper;

import com.emailage.javawrapper.model.ConfigurationParameters;
import com.emailage.javawrapper.model.Enums;
import com.emailage.javawrapper.model.ExtraInputParameter;
import com.emailage.javawrapper.model.exception.EmailageApiRequestException;
import com.emailage.javawrapper.model.exception.EmailageParameterException;
import com.emailage.javawrapper.model.response.EmailageResponse;
import com.emailage.javawrapper.utilities.AutoCloseableHttpsUrlConnection;
import com.emailage.javawrapper.utilities.HttpHelper;
import com.emailage.javawrapper.utilities.OAuth;
import com.emailage.javawrapper.utilities.OAuth2Wrapper;
import com.emailage.javawrapper.utilities.Validation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;

public class EmailageClient {
    private static final String RequestBaseUrlSand = "https://sandbox.emailage.com/emailagevalidator/";
    private static final String RequestBaseUrlProd = "https://api.emailage.com/emailagevalidator/";
    private static final String RequestBaseFraudUrlSand = "https://sandbox.emailage.com/emailageValidator/flag/";
    private static final String RequestBaseFraudUrlProd = "https://api.emailage.com/emailageValidator/flag/";
    private static final Logger Log = Logger.getLogger(EmailageClient.class.getName());
    private static final Pattern compiledUTF8Pattern = Pattern.compile("\ufeff");
    private static final ObjectMapper mapper = new ObjectMapper();
    public static HttpHelper httpHelper;

    public static EmailageResponse QueryEmail(String email, ConfigurationParameters parameters) throws IOException, EmailageApiRequestException {
        EmailageClient.validateParams(email, parameters.isValidateBeforeSending());
        String query = "query=" + URLEncoder.encode(email, StandardCharsets.UTF_8.name());
        String result = EmailageClient.PostQuery(APIUrl.Query, null, query, parameters);
        String decodedString = URLDecoder.decode(result, StandardCharsets.UTF_8.name());
        return EmailageClient.deserialize(decodedString);
    }

    public static EmailageResponse QueryEmailAndIP(String email, String IP, ConfigurationParameters parameters) throws IOException, EmailageApiRequestException {
        EmailageClient.validateParams(email, IP, parameters.isValidateBeforeSending());
        String queryElement = EmailageClient.constructQueryField(email, IP);
        StringBuffer queryBuffer = new StringBuffer("query=");
        queryBuffer.append(queryElement);
        String result = EmailageClient.PostQuery(APIUrl.Query, null, queryBuffer.toString(), parameters);
        String decodedString = URLDecoder.decode(result, StandardCharsets.UTF_8.name());
        return EmailageClient.deserialize(decodedString);
    }

    public static EmailageResponse QueryEmailAndIPPlusExtraArgs(String email, String IP, ExtraInputParameter extraArgs, ConfigurationParameters parameters) throws IOException, EmailageParameterException, EmailageApiRequestException {
        EmailageClient.validateParams(email, IP, parameters.isValidateBeforeSending());
        String queryElement = EmailageClient.constructQueryField(email, IP);
        StringBuffer queryBuffer = new StringBuffer("query=");
        queryBuffer.append(queryElement);
        queryBuffer.append(extraArgs.buildExtraInputParameterRequest());
        return EmailageClient.deserialize(EmailageClient.PostQuery(APIUrl.Query, null, queryBuffer.toString(), parameters));
    }

    public static EmailageResponse MarkEmailAsFraud(String email, Enums.FraudType fraudType, Enums.FraudCode fraudCode, ConfigurationParameters parameters) throws EmailageApiRequestException, IOException {
        String query = "query=" + URLEncoder.encode(email, StandardCharsets.UTF_8.name()) + "&fraudcodeID=" + fraudCode.toInt() + "&flag=" + (Object)((Object)fraudType);
        String result = EmailageClient.PostQuery(APIUrl.MarkAsFraud, fraudType, query, parameters);
        String decodedString = URLDecoder.decode(result, StandardCharsets.UTF_8.name());
        EmailageResponse response = EmailageClient.deserialize(decodedString);
        response.getQuery().setEmail(URLDecoder.decode(response.getQuery().getEmail(), StandardCharsets.UTF_8.name()));
        return response;
    }

    private static String PostQuery(APIUrl endpoint, Enums.FraudType fraudType, String urlParameters, ConfigurationParameters parameters) throws EmailageApiRequestException, MalformedURLException {
        String result = null;
        String resultFormat = parameters.getResultFormat().toString();
        String endpointurl = EmailageClient.getEndpointurl(endpoint, parameters);
        String oriUrl = null != fraudType ? endpointurl + "?flag=" + fraudType.toString() + "&format=" + resultFormat + "&" + urlParameters : endpointurl + "?format=" + resultFormat;
        switch (parameters.getAuthenticationType()) {
            case OAUTH1: {
                result = EmailageClient.PostOAuth1(fraudType, urlParameters, parameters, oriUrl);
                break;
            }
            case OAUTH2: {
                result = EmailageClient.PostOAuth2(fraudType, urlParameters, parameters, oriUrl);
            }
        }
        return result;
    }

    private static String PostOAuth2(Enums.FraudType fraudType, String urlParameters, ConfigurationParameters parameters, String oriUrl) throws MalformedURLException, EmailageApiRequestException {
        String answer;
        URL url = new URL(oriUrl);
        String tokenString = String.format("%s://%s/oauth/v2/token", url.getProtocol(), url.getHost());
        URL tokenUrl = new URL(tokenString);
        try {
            OAuth2Wrapper auth = OAuth2Wrapper.getInstance(parameters.getAcccountToken(), parameters.getAccountSecret(), tokenUrl, httpHelper);
            answer = auth.doOAuth2Request(url, urlParameters);
        }
        catch (Exception e1) {
            throw new EmailageApiRequestException("Could not complete API request", e1);
        }
        return answer;
    }

    private static String PostOAuth1(Enums.FraudType fraudType, String urlParameters, ConfigurationParameters parameters, String oriUrl) throws MalformedURLException, EmailageApiRequestException {
        String answer;
        String hashAlgorithmString = parameters.getHashAlgorithm().toString();
        if (parameters.getUserEmail() != null && parameters.getUserEmail().trim().length() > 0) {
            oriUrl = oriUrl + "&user_email=" + parameters.getUserEmail();
        }
        String requestUrl = OAuth.getUrl("POST", hashAlgorithmString, oriUrl, parameters.getAccountSecret(), parameters.getAcccountToken());
        Log.finer("requestUrl: " + requestUrl);
        byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
        URL url = new URL(requestUrl);
        try {
            HttpsURLConnection conn = httpHelper.getHttpsURLConnection(url);
            try (AutoCloseableHttpsUrlConnection conc = new AutoCloseableHttpsUrlConnection(conn);){
                answer = httpHelper.PostRequest(postData, conn);
            }
        }
        catch (Exception e1) {
            throw new EmailageApiRequestException("Could not complete API request", e1);
        }
        return answer;
    }

    private static String getEndpointurl(APIUrl endpoint, ConfigurationParameters parameters) {
        String result = null;
        if (parameters.getEnvironment() == Enums.Environment.Production && endpoint == APIUrl.Query) {
            result = RequestBaseUrlProd;
        } else if (parameters.getEnvironment() == Enums.Environment.Sandbox && endpoint == APIUrl.Query) {
            result = RequestBaseUrlSand;
        } else if (parameters.getEnvironment() == Enums.Environment.Production && endpoint == APIUrl.MarkAsFraud) {
            result = RequestBaseFraudUrlProd;
        } else if (parameters.getEnvironment() == Enums.Environment.Sandbox && endpoint == APIUrl.MarkAsFraud) {
            result = RequestBaseFraudUrlSand;
        }
        if (parameters.getAuthenticationType() == Enums.AuthenticationType.OAUTH2) {
            result = result.concat("v2");
        }
        return result;
    }

    private static EmailageResponse deserialize(String response) throws IOException {
        Matcher matcher = compiledUTF8Pattern.matcher(response.trim());
        EmailageResponse query = (EmailageResponse)mapper.readValue(matcher.replaceFirst(""), EmailageResponse.class);
        query.getQuery().setRaw(response);
        return query;
    }

    private static boolean validateParams(String email, boolean isValidationActive) throws IllegalArgumentException {
        if (isValidationActive && !Validation.validateEmail(email)) {
            throw new IllegalArgumentException("Email supplied is not valid : " + email);
        }
        return true;
    }

    private static boolean validateParams(String email, String ipAddress, boolean isValidationActive) throws IllegalArgumentException {
        if (isValidationActive) {
            if (email == null && ipAddress == null) {
                throw new IllegalArgumentException("Email or Ip Address must be supplied");
            }
            if (email != null && !Validation.validateEmail(email)) {
                throw new IllegalArgumentException("Email supplied is not valid : " + email);
            }
            if (ipAddress != null && !Validation.validateIpAddress(ipAddress)) {
                throw new IllegalArgumentException("Ip Address supplied is not a valid ipv4 or ipv6 address : " + email);
            }
        }
        return true;
    }

    private static String constructQueryField(String email, String IP) throws UnsupportedEncodingException {
        StringBuffer queryElement = new StringBuffer();
        if (email != null) {
            queryElement.append(email);
        }
        if (email != null && IP != null) {
            queryElement.append("+");
        }
        if (IP != null) {
            queryElement.append(IP);
        }
        return URLEncoder.encode(queryElement.toString(), StandardCharsets.UTF_8.name());
    }

    static {
        mapper.registerModule((Module)new AfterburnerModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        httpHelper = new HttpHelper();
    }

    private static enum APIUrl {
        Query,
        MarkAsFraud;

    }
}

