/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.internal.printer.file.backup;

import com.elvishew.xlog.printer.file.backup.BackupStrategy2;
import java.io.File;

public class BackupUtil {
    public static void backup(File loggingFile, BackupStrategy2 backupStrategy) {
        String loggingFileName = loggingFile.getName();
        String path = loggingFile.getParent();
        int maxBackupIndex = backupStrategy.getMaxBackupIndex();
        if (maxBackupIndex > 0) {
            File nextBackupFile;
            File backupFile = new File(path, backupStrategy.getBackupFileName(loggingFileName, maxBackupIndex));
            if (backupFile.exists()) {
                backupFile.delete();
            }
            for (int i = maxBackupIndex - 1; i > 0; --i) {
                backupFile = new File(path, backupStrategy.getBackupFileName(loggingFileName, i));
                if (!backupFile.exists()) continue;
                nextBackupFile = new File(path, backupStrategy.getBackupFileName(loggingFileName, i + 1));
                backupFile.renameTo(nextBackupFile);
            }
            nextBackupFile = new File(path, backupStrategy.getBackupFileName(loggingFileName, 1));
            loggingFile.renameTo(nextBackupFile);
        } else if (maxBackupIndex == 0) {
            for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                File nextBackupFile = new File(path, backupStrategy.getBackupFileName(loggingFileName, i));
                if (nextBackupFile.exists()) continue;
                loggingFile.renameTo(nextBackupFile);
                break;
            }
        }
    }

    public static void verifyBackupStrategy(BackupStrategy2 backupStrategy) {
        int maxBackupIndex = backupStrategy.getMaxBackupIndex();
        if (maxBackupIndex < 0) {
            throw new IllegalArgumentException("Max backup index should not be less than 0");
        }
        if (maxBackupIndex == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Max backup index too big: " + maxBackupIndex);
        }
    }
}

