/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.yaml;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.concurrent.ConcurrentConfig;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.yaml.YamlFormat;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public final class YamlParser
implements ConfigParser<Config> {
    private final Yaml yaml;
    private final ConfigFormat<Config> configFormat;

    public YamlParser() {
        this(YamlFormat.defaultInstance());
    }

    public YamlParser(YamlFormat configFormat) {
        this.yaml = configFormat.yaml;
        this.configFormat = configFormat;
    }

    public YamlParser(Yaml yaml) {
        this.yaml = yaml;
        this.configFormat = YamlFormat.configuredInstance(yaml);
    }

    public YamlParser(LoaderOptions options) {
        this(new Yaml(options));
    }

    public ConfigFormat<Config> getFormat() {
        return this.configFormat;
    }

    public Config parse(Reader reader) {
        Config config = this.configFormat.createConfig();
        this.parse(reader, config, ParsingMode.MERGE);
        return config;
    }

    public void parse(Reader reader, Config destination, ParsingMode parsingMode) {
        if (destination instanceof ConcurrentConfig) {
            ((ConcurrentConfig)destination).bulkUpdate(view -> this.parse(reader, (Config)view, parsingMode));
            return;
        }
        try {
            Map map = (Map)this.yaml.loadAs(reader, Map.class);
            parsingMode.prepareParsing(destination);
            for (Map.Entry entry : map.entrySet()) {
                parsingMode.put(destination, Collections.singletonList(entry.getKey()), YamlParser.convertValue(entry.getValue(), destination));
            }
        }
        catch (Exception e) {
            throw new ParsingException("YAML parsing failed", (Throwable)e);
        }
    }

    private static Object convertValue(Object v, Config parentConfig) {
        if (v instanceof Map) {
            Map map = (Map)v;
            Config sub = parentConfig.createSubConfig();
            for (Map.Entry entry : map.entrySet()) {
                sub.set(Collections.singletonList(entry.getKey()), YamlParser.convertValue(entry.getValue(), sub));
            }
            return sub;
        }
        if (v instanceof List) {
            List list = (List)v;
            list.replaceAll(e -> YamlParser.convertValue(e, parentConfig));
            return list;
        }
        return v;
    }
}

