/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.hocon;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.hocon.HoconFormat;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigUtil;
import com.typesafe.config.ConfigValue;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HoconParser
implements ConfigParser<CommentedConfig> {
    private static final ConfigParseOptions OPTIONS = ConfigParseOptions.defaults().setAllowMissing(false).setSyntax(ConfigSyntax.CONF);

    public ConfigFormat<CommentedConfig> getFormat() {
        return HoconFormat.instance();
    }

    public CommentedConfig parse(Reader reader) {
        CommentedConfig config = HoconFormat.instance().createConfig();
        this.parse(reader, (Config)config, ParsingMode.MERGE);
        return config;
    }

    public void parse(Reader reader, Config destination, ParsingMode parsingMode) {
        try {
            ConfigObject parsed = ConfigFactory.parseReader((Reader)reader, (ConfigParseOptions)OPTIONS).resolve().root();
            parsingMode.prepareParsing(destination);
            if (destination instanceof CommentedConfig) {
                HoconParser.put(parsed, (CommentedConfig)destination, parsingMode);
            } else {
                HoconParser.put(parsed, destination, parsingMode);
            }
        }
        catch (Exception e) {
            throw new ParsingException("HOCON parsing failed", (Throwable)e);
        }
    }

    private static void put(ConfigObject typesafeConfig, Config destination, ParsingMode parsingMode) {
        for (Map.Entry entry : typesafeConfig.entrySet()) {
            List path = ConfigUtil.splitPath((String)((String)entry.getKey()));
            parsingMode.put(destination, path, HoconParser.unwrap(((ConfigValue)entry.getValue()).unwrapped()));
        }
    }

    private static void put(ConfigObject typesafeConfig, CommentedConfig destination, ParsingMode parsingMode) {
        for (Map.Entry entry : typesafeConfig.entrySet()) {
            List path = ConfigUtil.splitPath((String)((String)entry.getKey()));
            ConfigValue value = (ConfigValue)entry.getValue();
            parsingMode.put((Config)destination, path, HoconParser.unwrap(value.unwrapped()));
            List comments = value.origin().comments();
            if (comments.isEmpty()) continue;
            destination.setComment(path, String.join((CharSequence)"\n", value.origin().comments()));
        }
    }

    private static Object unwrap(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            HashMap unwrappedMap = new HashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                unwrappedMap.put(entry.getKey(), HoconParser.unwrap(entry.getValue()));
            }
            return Config.wrap(unwrappedMap, (ConfigFormat)HoconFormat.instance());
        }
        if (o instanceof List) {
            List list = (List)o;
            if (!list.isEmpty() && list.get(0) instanceof Map) {
                ArrayList<Config> configList = new ArrayList<Config>();
                for (Object element : list) {
                    configList.add((Config)HoconParser.unwrap(element));
                }
                return configList;
            }
        } else if (o == null) {
            return NullObject.NULL_OBJECT;
        }
        return o;
    }
}

