/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.core;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public interface UnmodifiableConfig {
    default public <T> T get(String path) {
        return this.get(StringUtils.split(path, '.'));
    }

    public <T> T get(List<String> var1);

    default public <T> Optional<T> getOptional(String path) {
        return this.getOptional(StringUtils.split(path, '.'));
    }

    default public <T> Optional<T> getOptional(List<String> path) {
        return Optional.ofNullable(this.get(path));
    }

    default public <T> T getOrElse(String path, T defaultValue) {
        T value = this.get(path);
        return value == null ? defaultValue : value;
    }

    default public <T> T getOrElse(List<String> path, T defaultValue) {
        T value = this.get(path);
        return value == null ? defaultValue : value;
    }

    default public <T> T getOrElse(List<String> path, Supplier<T> defaultValueSupplier) {
        T value = this.get(path);
        return value == null ? defaultValueSupplier.get() : value;
    }

    default public <T> T getOrElse(String path, Supplier<T> defaultValueSupplier) {
        T value = this.get(path);
        return value == null ? defaultValueSupplier.get() : value;
    }

    default public int getInt(String path) {
        return ((Number)this.get(path)).intValue();
    }

    default public int getInt(List<String> path) {
        return ((Number)this.get(path)).intValue();
    }

    default public OptionalInt getOptionalInt(String path) {
        return this.getOptionalInt(StringUtils.split(path, '.'));
    }

    default public OptionalInt getOptionalInt(List<String> path) {
        Number n = (Number)this.get(path);
        return n == null ? OptionalInt.empty() : OptionalInt.of(n.intValue());
    }

    default public int getIntOrElse(String path, int defaultValue) {
        return this.getIntOrElse(StringUtils.split(path, '.'), defaultValue);
    }

    default public int getIntOrElse(List<String> path, int defaultValue) {
        Number n = (Number)this.get(path);
        return n == null ? defaultValue : n.intValue();
    }

    default public int getIntOrElse(String path, IntSupplier defaultValueSupplier) {
        return this.getIntOrElse(StringUtils.split(path, '.'), defaultValueSupplier);
    }

    default public int getIntOrElse(List<String> path, IntSupplier defaultValueSupplier) {
        Number n = (Number)this.get(path);
        return n == null ? defaultValueSupplier.getAsInt() : n.intValue();
    }

    default public long getLong(String path) {
        return ((Number)this.get(path)).longValue();
    }

    default public long getLong(List<String> path) {
        return ((Number)this.get(path)).longValue();
    }

    default public OptionalLong getOptionalLong(String path) {
        return this.getOptionalLong(StringUtils.split(path, '.'));
    }

    default public OptionalLong getOptionalLong(List<String> path) {
        Number n = (Number)this.get(path);
        return n == null ? OptionalLong.empty() : OptionalLong.of(n.longValue());
    }

    default public long getLongOrElse(String path, long defaultValue) {
        return this.getLongOrElse(StringUtils.split(path, '.'), defaultValue);
    }

    default public long getLongOrElse(List<String> path, long defaultValue) {
        Number n = (Number)this.get(path);
        return n == null ? defaultValue : n.longValue();
    }

    default public long getLongOrElse(String path, LongSupplier defaultValueSupplier) {
        return this.getLongOrElse(StringUtils.split(path, '.'), defaultValueSupplier);
    }

    default public long getLongOrElse(List<String> path, LongSupplier defaultValueSupplier) {
        Number n = (Number)this.get(path);
        return n == null ? defaultValueSupplier.getAsLong() : n.longValue();
    }

    default public byte getByte(String path) {
        return ((Number)this.get(path)).byteValue();
    }

    default public byte getByte(List<String> path) {
        return ((Number)this.get(path)).byteValue();
    }

    default public byte getByteOrElse(String path, byte defaultValue) {
        return this.getByteOrElse(StringUtils.split(path, '.'), defaultValue);
    }

    default public byte getByteOrElse(List<String> path, byte defaultValue) {
        Number n = (Number)this.get(path);
        return n == null ? defaultValue : n.byteValue();
    }

    default public short getShort(String path) {
        return ((Number)this.get(path)).shortValue();
    }

    default public short getShort(List<String> path) {
        return ((Number)this.get(path)).shortValue();
    }

    default public short getShortOrElse(String path, short defaultValue) {
        return this.getShortOrElse(StringUtils.split(path, '.'), defaultValue);
    }

    default public short getShortOrElse(List<String> path, short defaultValue) {
        Number n = (Number)this.get(path);
        return n == null ? defaultValue : n.shortValue();
    }

    default public char getChar(String path) {
        return (char)this.getInt(path);
    }

    default public char getChar(List<String> path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            return (char)((Number)value).intValue();
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).charAt(0);
        }
        return ((Character)value).charValue();
    }

    default public char getCharOrElse(String path, char defaultValue) {
        return this.getCharOrElse(StringUtils.split(path, '.'), defaultValue);
    }

    default public char getCharOrElse(List<String> path, char defaultValue) {
        Object value = this.get(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return (char)((Number)value).intValue();
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).charAt(0);
        }
        return ((Character)value).charValue();
    }

    default public boolean contains(String path) {
        return this.contains(StringUtils.split(path, '.'));
    }

    public boolean contains(List<String> var1);

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public Map<String, Object> valueMap();

    public Set<? extends Entry> entrySet();

    public ConfigFormat<?> configFormat();

    default public <T> T apply(String path) {
        return this.get(path);
    }

    default public <T> T apply(List<String> path) {
        return this.get(path);
    }

    public static interface Entry {
        public String getKey();

        public <T> T getValue();
    }
}

