/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.core;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public interface UnmodifiableConfig {
    default public <T> T get(String path) {
        return this.get(StringUtils.split(path, '.'));
    }

    public <T> T get(List<String> var1);

    default public <T> Optional<T> getOptional(String path) {
        return this.getOptional(StringUtils.split(path, '.'));
    }

    default public <T> Optional<T> getOptional(List<String> path) {
        return Optional.ofNullable(this.get(path));
    }

    default public <T> T getOrElse(String path, T defaultValue) {
        T value = this.get(path);
        return value == null ? defaultValue : value;
    }

    default public <T> T getOrElse(List<String> path, T defaultValue) {
        T value = this.get(path);
        return value == null ? defaultValue : value;
    }

    default public <T> T getOrElse(List<String> path, Supplier<T> defaultValueSupplier) {
        T value = this.get(path);
        return value == null ? defaultValueSupplier.get() : value;
    }

    default public <T> T getOrElse(String path, Supplier<T> defaultValueSupplier) {
        T value = this.get(path);
        return value == null ? defaultValueSupplier.get() : value;
    }

    default public boolean contains(String path) {
        return this.contains(StringUtils.split(path, '.'));
    }

    public boolean contains(List<String> var1);

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public Map<String, Object> valueMap();

    public Set<? extends Entry> entrySet();

    public ConfigFormat<?> configFormat();

    default public <T> T apply(String path) {
        return this.get(path);
    }

    default public <T> T apply(List<String> path) {
        return this.get(path);
    }

    public static interface Entry {
        public String getKey();

        public <T> T getValue();
    }
}

