/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx;

import gigahorse.shaded.ahc.io.netty.handler.codec.http.DefaultFullHttpResponse;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.FullHttpRequest;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.FullHttpResponse;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpHeaderValues;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpResponseStatus;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpVersion;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import gigahorse.shaded.ahc.io.netty.util.CharsetUtil;

public class WebSocketServerHandshaker13
extends WebSocketServerHandshaker {
    public static final String WEBSOCKET_13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public WebSocketServerHandshaker13(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        this(webSocketURL, subprotocols, allowExtensions, maxFramePayloadLength, false);
    }

    public WebSocketServerHandshaker13(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength, boolean allowMaskMismatch) {
        this(webSocketURL, subprotocols, WebSocketDecoderConfig.newBuilder().allowExtensions(allowExtensions).maxFramePayloadLength(maxFramePayloadLength).allowMaskMismatch(allowMaskMismatch).build());
    }

    public WebSocketServerHandshaker13(String webSocketURL, String subprotocols, WebSocketDecoderConfig decoderConfig) {
        super(WebSocketVersion.V13, webSocketURL, subprotocols, decoderConfig);
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest req, HttpHeaders headers) {
        String key = req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY);
        if (key == null) {
            throw new WebSocketServerHandshakeException("not a WebSocket request: missing key", req);
        }
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, req.content().alloc().buffer(0));
        if (headers != null) {
            res.headers().add(headers);
        }
        String acceptSeed = key + WEBSOCKET_13_ACCEPT_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        String accept = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 13 server handshake key: {}, response: {}", (Object)key, (Object)accept);
        }
        res.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (Object)accept);
        String subprotocols = req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requested subprotocol(s) not supported: {}", (Object)subprotocols);
                }
            } else {
                res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)selectedSubprotocol);
            }
        }
        return res;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(this.decoderConfig());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(false);
    }
}

