/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.ws;

import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseHeaders;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import gigahorse.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import gigahorse.shaded.ahc.org.asynchttpclient.ws.UpgradeHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.ws.WebSocket;
import gigahorse.shaded.ahc.org.asynchttpclient.ws.WebSocketListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebSocketUpgradeHandler
implements UpgradeHandler<WebSocket>,
AsyncHandler<WebSocket> {
    private static final int SWITCHING_PROTOCOLS = gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpResponseStatus.SWITCHING_PROTOCOLS.code();
    private WebSocket webSocket;
    private final List<WebSocketListener> listeners;
    private final AtomicBoolean ok = new AtomicBoolean(false);
    private boolean onSuccessCalled;
    private int status;
    private List<Runnable> bufferedFrames;

    public WebSocketUpgradeHandler(List<WebSocketListener> listeners) {
        this.listeners = listeners;
    }

    public void bufferFrame(Runnable bufferedFrame) {
        if (this.bufferedFrames == null) {
            this.bufferedFrames = new ArrayList<Runnable>(1);
        }
        this.bufferedFrames.add(bufferedFrame);
    }

    @Override
    public final void onThrowable(Throwable t) {
        this.onFailure(t);
    }

    public boolean touchSuccess() {
        boolean prev = this.onSuccessCalled;
        this.onSuccessCalled = true;
        return prev;
    }

    @Override
    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.status = responseStatus.getStatusCode();
        return this.status == SWITCHING_PROTOCOLS ? AsyncHandler.State.UPGRADE : AsyncHandler.State.ABORT;
    }

    @Override
    public final AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final WebSocket onCompleted() throws Exception {
        if (this.status != SWITCHING_PROTOCOLS) {
            IllegalStateException e = new IllegalStateException("Invalid Status Code " + this.status);
            for (WebSocketListener listener : this.listeners) {
                listener.onError(e);
            }
            throw e;
        }
        return this.webSocket;
    }

    @Override
    public final void onSuccess(WebSocket webSocket) {
        this.webSocket = webSocket;
        for (WebSocketListener listener : this.listeners) {
            webSocket.addWebSocketListener(listener);
            listener.onOpen(webSocket);
        }
        if (MiscUtils.isNonEmpty(this.bufferedFrames)) {
            for (Runnable bufferedFrame : this.bufferedFrames) {
                bufferedFrame.run();
            }
            this.bufferedFrames = null;
        }
        this.ok.set(true);
    }

    @Override
    public final void onFailure(Throwable t) {
        for (WebSocketListener listener : this.listeners) {
            if (!this.ok.get() && this.webSocket != null) {
                this.webSocket.addWebSocketListener(listener);
            }
            listener.onError(t);
        }
    }

    public static final class Builder {
        private List<WebSocketListener> listeners = new ArrayList<WebSocketListener>(1);

        public Builder addWebSocketListener(WebSocketListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder removeWebSocketListener(WebSocketListener listener) {
            this.listeners.remove(listener);
            return this;
        }

        public WebSocketUpgradeHandler build() {
            return new WebSocketUpgradeHandler(this.listeners);
        }
    }
}

