/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.request.body.generator;

import gigahorse.shaded.ahc.io.netty.buffer.ByteBuf;
import gigahorse.shaded.ahc.org.asynchttpclient.request.body.Body;
import gigahorse.shaded.ahc.org.asynchttpclient.request.body.generator.BodyGenerator;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputStreamBodyGenerator
implements BodyGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamBody.class);
    private final InputStream inputStream;
    private final long contentLength;

    public InputStreamBodyGenerator(InputStream inputStream) {
        this(inputStream, -1L);
    }

    public InputStreamBodyGenerator(InputStream inputStream, long contentLength) {
        this.inputStream = inputStream;
        this.contentLength = contentLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public Body createBody() {
        return new InputStreamBody(this.inputStream, this.contentLength);
    }

    private class InputStreamBody
    implements Body {
        private final InputStream inputStream;
        private final long contentLength;
        private byte[] chunk;

        private InputStreamBody(InputStream inputStream, long contentLength) {
            this.inputStream = inputStream;
            this.contentLength = contentLength;
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }

        @Override
        public Body.BodyState transferTo(ByteBuf target) throws IOException {
            this.chunk = new byte[target.writableBytes() - 10];
            int read = -1;
            boolean write = false;
            try {
                read = this.inputStream.read(this.chunk);
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to read", (Throwable)ex);
            }
            if (read > 0) {
                target.writeBytes(this.chunk, 0, read);
                write = true;
            }
            return write ? Body.BodyState.CONTINUE : Body.BodyState.STOP;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

