/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.timeout;

import gigahorse.shaded.ahc.io.netty.util.Timeout;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.timeout.TimeoutsHolder;
import gigahorse.shaded.ahc.org.asynchttpclient.util.DateUtils;

public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    private final long requestTimeout;

    public RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, int requestTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.requestTimeout = requestTimeout;
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        this.timeoutsHolder.cancel();
        if (this.nettyResponseFuture.isDone()) {
            return;
        }
        String message = "Request timeout to " + this.timeoutsHolder.remoteAddress() + " after " + this.requestTimeout + " ms";
        long age = DateUtils.unpreciseMillisTime() - this.nettyResponseFuture.getStart();
        this.expire(message, age);
    }
}

