/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body;

import gigahorse.shaded.ahc.com.typesafe.netty.HandlerSubscriber;
import gigahorse.shaded.ahc.io.netty.buffer.ByteBuf;
import gigahorse.shaded.ahc.io.netty.buffer.Unpooled;
import gigahorse.shaded.ahc.io.netty.channel.Channel;
import gigahorse.shaded.ahc.io.netty.channel.ChannelHandler;
import gigahorse.shaded.ahc.io.netty.channel.EventLoop;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.DefaultHttpContent;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpContent;
import gigahorse.shaded.ahc.io.netty.handler.codec.http.LastHttpContent;
import gigahorse.shaded.ahc.io.netty.util.concurrent.Future;
import gigahorse.shaded.ahc.io.netty.util.concurrent.GenericFutureListener;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body.NettyBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyReactiveStreamsBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyReactiveStreamsBody.class);
    private static final String NAME_IN_CHANNEL_PIPELINE = "request-body-streamer";
    private final Publisher<ByteBuffer> publisher;
    private final long contentLength;

    public NettyReactiveStreamsBody(Publisher<ByteBuffer> publisher, long contentLength) {
        this.publisher = publisher;
        this.contentLength = contentLength;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) throws IOException {
        if (future.isStreamConsumed()) {
            LOGGER.warn("Stream has already been consumed and cannot be reset");
        } else {
            future.setStreamConsumed(true);
            NettySubscriber subscriber = new NettySubscriber(channel, future);
            channel.pipeline().addLast(NAME_IN_CHANNEL_PIPELINE, (ChannelHandler)subscriber);
            this.publisher.subscribe((Subscriber)new SubscriberAdapter(subscriber));
        }
    }

    private static class NettySubscriber
    extends HandlerSubscriber<HttpContent> {
        private static final Logger LOGGER = LoggerFactory.getLogger(NettySubscriber.class);
        private final Channel channel;
        private final NettyResponseFuture<?> future;

        public NettySubscriber(Channel channel, NettyResponseFuture<?> future) {
            super(channel.eventLoop());
            this.channel = channel;
            this.future = future;
        }

        @Override
        protected void complete() {
            EventLoop executor = this.channel.eventLoop();
            executor.execute(() -> this.channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.removeFromPipeline())));
        }

        @Override
        protected void error(Throwable error) {
            if (error == null) {
                throw null;
            }
            this.removeFromPipeline();
            this.future.abort(error);
        }

        private void removeFromPipeline() {
            try {
                this.channel.pipeline().remove(this);
                LOGGER.debug(String.format("Removed handler %s from pipeline.", NettyReactiveStreamsBody.NAME_IN_CHANNEL_PIPELINE));
            }
            catch (NoSuchElementException e) {
                LOGGER.debug(String.format("Failed to remove handler %s from pipeline.", NettyReactiveStreamsBody.NAME_IN_CHANNEL_PIPELINE), (Throwable)e);
            }
        }
    }

    private static class SubscriberAdapter
    implements Subscriber<ByteBuffer> {
        private volatile Subscriber<HttpContent> subscriber;

        public SubscriberAdapter(Subscriber<HttpContent> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription s) {
            this.subscriber.onSubscribe(s);
        }

        public void onNext(ByteBuffer t) {
            ByteBuf buffer = Unpooled.wrappedBuffer(t.array());
            DefaultHttpContent content = new DefaultHttpContent(buffer);
            this.subscriber.onNext((Object)content);
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

