/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.request.body;

import gigahorse.shaded.ahc.io.netty.buffer.ByteBuf;
import gigahorse.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import gigahorse.shaded.ahc.io.netty.handler.stream.ChunkedInput;
import gigahorse.shaded.ahc.org.asynchttpclient.request.body.Body;
import gigahorse.shaded.ahc.org.asynchttpclient.util.Assertions;

public class BodyChunkedInput
implements ChunkedInput<ByteBuf> {
    public static final int DEFAULT_CHUNK_SIZE = 8192;
    private final Body body;
    private final int chunkSize;
    private boolean endOfInput;

    public BodyChunkedInput(Body body) {
        this.body = Assertions.assertNotNull(body, "body");
        long contentLength = body.getContentLength();
        this.chunkSize = contentLength <= 0L ? 8192 : (int)Math.min(contentLength, 8192L);
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        if (this.endOfInput) {
            return null;
        }
        ByteBuf buffer = ctx.alloc().buffer(this.chunkSize);
        Body.BodyState state = this.body.transferTo(buffer);
        switch (state) {
            case STOP: {
                this.endOfInput = true;
                return buffer;
            }
            case SUSPEND: {
                buffer.release();
                return null;
            }
            case CONTINUE: {
                return buffer;
            }
        }
        throw new IllegalStateException("Unknown state: " + (Object)((Object)state));
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.endOfInput;
    }

    @Override
    public void close() throws Exception {
        this.body.close();
    }
}

