/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.netty.handler.intercept;

import gigahorse.shaded.ahc.io.netty.channel.Channel;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseHeaders;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import gigahorse.shaded.ahc.org.asynchttpclient.filter.FilterContext;
import gigahorse.shaded.ahc.org.asynchttpclient.filter.FilterException;
import gigahorse.shaded.ahc.org.asynchttpclient.filter.ResponseFilter;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import gigahorse.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import gigahorse.shaded.ahc.org.asynchttpclient.util.Assertions;

public class ResponseFiltersInterceptor {
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;

    public ResponseFiltersInterceptor(AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.config = config;
        this.requestSender = requestSender;
    }

    public boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpResponseHeaders responseHeaders) {
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getCurrentRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
        for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
            try {
                fc = asyncFilter.filter(fc);
                Assertions.assertNotNull("fc", "filterContext");
            }
            catch (FilterException efe) {
                this.requestSender.abort(channel, future, efe);
            }
        }
        future.setAsyncHandler(fc.getAsyncHandler());
        if (fc.replayRequest()) {
            this.requestSender.replayRequest(future, fc, channel);
            return true;
        }
        return false;
    }
}

