/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient.handler;

import gigahorse.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncCompletionHandlerBase;
import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseHeaders;
import gigahorse.shaded.ahc.org.asynchttpclient.Response;
import gigahorse.shaded.ahc.org.asynchttpclient.handler.TransferListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferCompletionHandler
extends AsyncCompletionHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(TransferCompletionHandler.class);
    private final ConcurrentLinkedQueue<TransferListener> listeners = new ConcurrentLinkedQueue();
    private final boolean accumulateResponseBytes;
    private HttpHeaders headers;

    public TransferCompletionHandler() {
        this(false);
    }

    public TransferCompletionHandler(boolean accumulateResponseBytes) {
        this.accumulateResponseBytes = accumulateResponseBytes;
    }

    public TransferCompletionHandler addTransferListener(TransferListener t) {
        this.listeners.offer(t);
        return this;
    }

    public TransferCompletionHandler removeTransferListener(TransferListener t) {
        this.listeners.remove(t);
        return this;
    }

    public void headers(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.fireOnHeaderReceived(headers.getHeaders());
        return super.onHeadersReceived(headers);
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        AsyncHandler.State s = AsyncHandler.State.CONTINUE;
        if (this.accumulateResponseBytes) {
            s = super.onBodyPartReceived(content);
        }
        this.fireOnBytesReceived(content.getBodyPartBytes());
        return s;
    }

    @Override
    public Response onCompleted(Response response) throws Exception {
        this.fireOnEnd();
        return response;
    }

    @Override
    public AsyncHandler.State onHeadersWritten() {
        if (this.headers != null) {
            this.fireOnHeadersSent(this.headers);
        }
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onContentWriteProgress(long amount, long current, long total) {
        this.fireOnBytesSent(amount, current, total);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.fireOnThrowable(t);
    }

    private void fireOnHeadersSent(HttpHeaders headers) {
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestHeadersSent(headers);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnHeaderReceived(HttpHeaders headers) {
        for (TransferListener l : this.listeners) {
            try {
                l.onResponseHeadersReceived(headers);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnEnd() {
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestResponseCompleted();
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnBytesReceived(byte[] b) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesReceived(b);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnBytesSent(long amount, long current, long total) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesSent(amount, current, total);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnThrowable(Throwable t) {
        for (TransferListener l : this.listeners) {
            try {
                l.onThrowable(t);
            }
            catch (Throwable t2) {
                logger.warn("onThrowable", t2);
            }
        }
    }
}

