/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.org.asynchttpclient;

import gigahorse.shaded.ahc.org.asynchttpclient.AsyncHandler;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseBodyPart;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseHeaders;
import gigahorse.shaded.ahc.org.asynchttpclient.HttpResponseStatus;
import gigahorse.shaded.ahc.org.asynchttpclient.Response;
import gigahorse.shaded.ahc.org.asynchttpclient.handler.ProgressAsyncHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncCompletionHandler<T>
implements AsyncHandler<T>,
ProgressAsyncHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCompletionHandler.class);
    private final Response.ResponseBuilder builder = new Response.ResponseBuilder();

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.builder.accumulate(content);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        this.builder.reset();
        this.builder.accumulate(status);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.builder.accumulate(headers);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final T onCompleted() throws Exception {
        return this.onCompleted(this.builder.build());
    }

    @Override
    public void onThrowable(Throwable t) {
        LOGGER.debug(t.getMessage(), t);
    }

    public abstract T onCompleted(Response var1) throws Exception;

    @Override
    public AsyncHandler.State onHeadersWritten() {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onContentWritten() {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onContentWriteProgress(long amount, long current, long total) {
        return AsyncHandler.State.CONTINUE;
    }
}

