/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.io.netty.channel;

import gigahorse.shaded.ahc.io.netty.channel.Channel;
import gigahorse.shaded.ahc.io.netty.channel.ChannelFuture;
import gigahorse.shaded.ahc.io.netty.channel.ChannelPromise;
import gigahorse.shaded.ahc.io.netty.channel.DefaultChannelPromise;
import gigahorse.shaded.ahc.io.netty.channel.EventLoop;
import gigahorse.shaded.ahc.io.netty.channel.EventLoopGroup;
import gigahorse.shaded.ahc.io.netty.util.concurrent.RejectedExecutionHandler;
import gigahorse.shaded.ahc.io.netty.util.concurrent.RejectedExecutionHandlers;
import gigahorse.shaded.ahc.io.netty.util.concurrent.SingleThreadEventExecutor;
import gigahorse.shaded.ahc.io.netty.util.internal.SystemPropertyUtil;
import java.util.concurrent.ThreadFactory;

public abstract class SingleThreadEventLoop
extends SingleThreadEventExecutor
implements EventLoop {
    protected static final int DEFAULT_MAX_PENDING_TASKS = Math.max(16, SystemPropertyUtil.getInt("gigahorse.shaded.ahc.io.netty.eventLoop.maxPendingTasks", Integer.MAX_VALUE));

    protected SingleThreadEventLoop(EventLoopGroup parent, ThreadFactory threadFactory, boolean addTaskWakesUp) {
        this(parent, threadFactory, addTaskWakesUp, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
    }

    protected SingleThreadEventLoop(EventLoopGroup parent, ThreadFactory threadFactory, boolean addTaskWakesUp, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler) {
        super(parent, threadFactory, addTaskWakesUp, maxPendingTasks, rejectedExecutionHandler);
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(channel, new DefaultChannelPromise(channel, this));
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        channel.unsafe().register(this, promise);
        return promise;
    }

    @Override
    protected boolean wakesUpForTask(Runnable task) {
        return !(task instanceof NonWakeupRunnable);
    }

    static interface NonWakeupRunnable
    extends Runnable {
    }
}

