/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.ahc.io.netty.buffer;

import gigahorse.shaded.ahc.io.netty.buffer.ByteBuf;
import gigahorse.shaded.ahc.io.netty.buffer.CompositeByteBuf;
import gigahorse.shaded.ahc.io.netty.buffer.SimpleLeakAwareByteBuf;
import gigahorse.shaded.ahc.io.netty.buffer.WrappedCompositeByteBuf;
import gigahorse.shaded.ahc.io.netty.util.ResourceLeakTracker;
import gigahorse.shaded.ahc.io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

class SimpleLeakAwareCompositeByteBuf
extends WrappedCompositeByteBuf {
    final ResourceLeakTracker<ByteBuf> leak;

    SimpleLeakAwareCompositeByteBuf(CompositeByteBuf wrapped, ResourceLeakTracker<ByteBuf> leak) {
        super(wrapped);
        this.leak = ObjectUtil.checkNotNull(leak, "leak");
    }

    @Override
    public boolean release() {
        ByteBuf unwrapped = this.unwrap();
        if (super.release()) {
            this.closeLeak(unwrapped);
            return true;
        }
        return false;
    }

    @Override
    public boolean release(int decrement) {
        ByteBuf unwrapped = this.unwrap();
        if (super.release(decrement)) {
            this.closeLeak(unwrapped);
            return true;
        }
        return false;
    }

    private void closeLeak(ByteBuf trackedByteBuf) {
        boolean closed = this.leak.close(trackedByteBuf);
        assert (closed);
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        if (this.order() == endianness) {
            return this;
        }
        return this.newLeakAwareByteBuf(super.order(endianness));
    }

    @Override
    public ByteBuf slice() {
        return this.newLeakAwareByteBuf(super.slice());
    }

    @Override
    public ByteBuf slice(int index, int length) {
        return this.newLeakAwareByteBuf(super.slice(index, length));
    }

    @Override
    public ByteBuf duplicate() {
        return this.newLeakAwareByteBuf(super.duplicate());
    }

    @Override
    public ByteBuf readSlice(int length) {
        return this.newLeakAwareByteBuf(super.readSlice(length));
    }

    private SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf wrapped) {
        return this.newLeakAwareByteBuf(wrapped, this.unwrap(), this.leak);
    }

    protected SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf wrapped, ByteBuf trackedByteBuf, ResourceLeakTracker<ByteBuf> leakTracker) {
        return new SimpleLeakAwareByteBuf(wrapped, trackedByteBuf, leakTracker);
    }
}

