/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.hc.core5.http2.impl.nio;

import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Contract;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Internal;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.ThreadingBehavior;
import gigahorse.shaded.apache.org.apache.hc.core5.function.Callback;
import gigahorse.shaded.apache.org.apache.hc.core5.http.URIScheme;
import gigahorse.shaded.apache.org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import gigahorse.shaded.apache.org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import gigahorse.shaded.apache.org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import gigahorse.shaded.apache.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import gigahorse.shaded.apache.org.apache.hc.core5.http2.HttpVersionPolicy;
import gigahorse.shaded.apache.org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import gigahorse.shaded.apache.org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import gigahorse.shaded.apache.org.apache.hc.core5.http2.impl.nio.ClientH2UpgradeHandler;
import gigahorse.shaded.apache.org.apache.hc.core5.http2.impl.nio.ClientHttp1UpgradeHandler;
import gigahorse.shaded.apache.org.apache.hc.core5.http2.impl.nio.HttpProtocolNegotiator;
import gigahorse.shaded.apache.org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import gigahorse.shaded.apache.org.apache.hc.core5.reactor.EndpointParameters;
import gigahorse.shaded.apache.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import gigahorse.shaded.apache.org.apache.hc.core5.reactor.ProtocolIOSession;
import gigahorse.shaded.apache.org.apache.hc.core5.util.Args;
import gigahorse.shaded.apache.org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ClientHttpProtocolNegotiationStarter
implements IOEventHandlerFactory {
    private final ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;
    private final Callback<Exception> exceptionCallback;

    public ClientHttpProtocolNegotiationStarter(ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory, ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy, TlsStrategy tlsStrategy, Timeout handshakeTimeout, Callback<Exception> exceptionCallback) {
        this.http1StreamHandlerFactory = Args.notNull(http1StreamHandlerFactory, "HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
        this.exceptionCallback = exceptionCallback;
    }

    @Override
    public HttpConnectionEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        HttpVersionPolicy endpointPolicy = this.versionPolicy;
        if (attachment instanceof EndpointParameters) {
            EndpointParameters params = (EndpointParameters)attachment;
            if (this.tlsStrategy != null && URIScheme.HTTPS.same(params.getScheme())) {
                this.tlsStrategy.upgrade(ioSession, params, params.getAttachment(), this.handshakeTimeout, null);
            }
            if (params.getAttachment() instanceof HttpVersionPolicy) {
                endpointPolicy = (HttpVersionPolicy)((Object)params.getAttachment());
            }
        }
        ioSession.registerProtocol(ApplicationProtocol.HTTP_1_1.id, new ClientHttp1UpgradeHandler(this.http1StreamHandlerFactory));
        ioSession.registerProtocol(ApplicationProtocol.HTTP_2.id, new ClientH2UpgradeHandler(this.http2StreamHandlerFactory, this.exceptionCallback));
        switch (endpointPolicy) {
            case FORCE_HTTP_2: {
                return new ClientH2PrefaceHandler(ioSession, this.http2StreamHandlerFactory, false, this.exceptionCallback);
            }
            case FORCE_HTTP_1: {
                return new ClientHttp1IOEventHandler(this.http1StreamHandlerFactory.create(ioSession));
            }
        }
        return new HttpProtocolNegotiator(ioSession, null);
    }
}

