/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.hc.core5.http.support;

import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Internal;
import gigahorse.shaded.apache.org.apache.hc.core5.http.EntityDetails;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpRequest;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpVersion;
import gigahorse.shaded.apache.org.apache.hc.core5.http.ProtocolException;
import gigahorse.shaded.apache.org.apache.hc.core5.http.message.MessageSupport;
import gigahorse.shaded.apache.org.apache.hc.core5.http.support.Expectation;
import gigahorse.shaded.apache.org.apache.hc.core5.util.TextUtils;
import java.util.concurrent.atomic.AtomicReference;

@Internal
public class ExpectSupport {
    public static Expectation parse(HttpRequest request, EntityDetails entityDetails) throws ProtocolException {
        if (request.getVersion() != null && request.getVersion().lessEquals(HttpVersion.HTTP_1_0)) {
            return null;
        }
        AtomicReference expectationRef = new AtomicReference();
        MessageSupport.parseTokens(request, "Expect", t -> {
            if (t.equalsIgnoreCase("100-continue")) {
                expectationRef.compareAndSet(null, Expectation.CONTINUE);
            } else if (!TextUtils.isBlank(t)) {
                expectationRef.set(Expectation.UNKNOWN);
            }
        });
        Expectation expectation = (Expectation)((Object)expectationRef.get());
        if (expectation == Expectation.CONTINUE && entityDetails == null) {
            throw new ProtocolException("Expect-Continue request without an enclosed entity");
        }
        return expectation;
    }
}

