/*
 * Decompiled with CFR 0.152.
 */
package com.edmodo.cropper.util;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.View;

public class ImageViewUtil {
    public static Rect getBitmapRectCenterInside(Bitmap bitmap, View view) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        return ImageViewUtil.getBitmapRectCenterInsideHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
    }

    public static Rect getBitmapRectCenterInside(int bitmapWidth, int bitmapHeight, int viewWidth, int viewHeight) {
        return ImageViewUtil.getBitmapRectCenterInsideHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
    }

    private static Rect getBitmapRectCenterInsideHelper(int bitmapWidth, int bitmapHeight, int viewWidth, int viewHeight) {
        int resultY;
        int resultX;
        double resultHeight;
        double resultWidth;
        double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
        double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
        if (viewWidth < bitmapWidth) {
            viewToBitmapWidthRatio = (double)viewWidth / (double)bitmapWidth;
        }
        if (viewHeight < bitmapHeight) {
            viewToBitmapHeightRatio = (double)viewHeight / (double)bitmapHeight;
        }
        if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
            if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                resultWidth = viewWidth;
                resultHeight = (double)bitmapHeight * resultWidth / (double)bitmapWidth;
            } else {
                resultHeight = viewHeight;
                resultWidth = (double)bitmapWidth * resultHeight / (double)bitmapHeight;
            }
        } else {
            resultHeight = bitmapHeight;
            resultWidth = bitmapWidth;
        }
        if (resultWidth == (double)viewWidth) {
            resultX = 0;
            resultY = (int)Math.round(((double)viewHeight - resultHeight) / 2.0);
        } else if (resultHeight == (double)viewHeight) {
            resultX = (int)Math.round(((double)viewWidth - resultWidth) / 2.0);
            resultY = 0;
        } else {
            resultX = (int)Math.round(((double)viewWidth - resultWidth) / 2.0);
            resultY = (int)Math.round(((double)viewHeight - resultHeight) / 2.0);
        }
        Rect result = new Rect(resultX, resultY, resultX + (int)Math.ceil(resultWidth), resultY + (int)Math.ceil(resultHeight));
        return result;
    }
}

